/*
 * Decompiled with CFR 0.152.
 */
package net.modificationstation.stationapi.impl.client.arsenic.renderer.render;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import net.modificationstation.stationapi.api.client.render.RenderContext;
import net.modificationstation.stationapi.api.client.render.mesh.MutableQuadView;
import net.modificationstation.stationapi.api.util.math.Matrix3f;
import net.modificationstation.stationapi.api.util.math.Matrix4f;

abstract class AbstractRenderContext
implements RenderContext {
    private final ObjectArrayList<RenderContext.QuadTransform> transformStack = new ObjectArrayList();
    private static final RenderContext.QuadTransform NO_TRANSFORM = q -> true;
    protected Matrix4f matrix;
    protected Matrix3f normalMatrix;
    protected int overlay;
    private final RenderContext.QuadTransform stackTransform = q -> {
        int i = this.transformStack.size() - 1;
        while (i >= 0) {
            if (((RenderContext.QuadTransform)this.transformStack.get(i--)).transform(q)) continue;
            return false;
        }
        return true;
    };
    private RenderContext.QuadTransform activeTransform = NO_TRANSFORM;

    AbstractRenderContext() {
    }

    protected final boolean transform(MutableQuadView q) {
        return this.activeTransform.transform(q);
    }

    protected boolean hasTransform() {
        return this.activeTransform != NO_TRANSFORM;
    }

    public void pushTransform(RenderContext.QuadTransform transform) {
        if (transform == null) {
            throw new NullPointerException("Renderer received null QuadTransform.");
        }
        this.transformStack.push((Object)transform);
        if (this.transformStack.size() == 1) {
            this.activeTransform = transform;
        } else if (this.transformStack.size() == 2) {
            this.activeTransform = this.stackTransform;
        }
    }

    public void popTransform() {
        this.transformStack.pop();
        if (this.transformStack.size() == 0) {
            this.activeTransform = NO_TRANSFORM;
        } else if (this.transformStack.size() == 1) {
            this.activeTransform = (RenderContext.QuadTransform)this.transformStack.get(0);
        }
    }
}

