/*
 * Decompiled with CFR 0.152.
 */
package net.modificationstation.stationapi.impl.client.arsenic.renderer.render;

import com.google.common.collect.ImmutableList;
import com.google.common.primitives.Ints;
import java.nio.ByteOrder;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Random;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_124;
import net.minecraft.class_127;
import net.minecraft.class_14;
import net.minecraft.class_17;
import net.minecraft.class_18;
import net.minecraft.class_31;
import net.minecraft.class_339;
import net.minecraft.class_454;
import net.minecraft.class_583;
import net.minecraft.class_67;
import net.minecraft.class_76;
import net.minecraft.client.Minecraft;
import net.modificationstation.stationapi.api.block.BlockState;
import net.modificationstation.stationapi.api.client.StationRenderAPI;
import net.modificationstation.stationapi.api.client.color.block.BlockColors;
import net.modificationstation.stationapi.api.client.color.item.ItemColors;
import net.modificationstation.stationapi.api.client.render.item.ItemModels;
import net.modificationstation.stationapi.api.client.render.model.BakedModel;
import net.modificationstation.stationapi.api.client.render.model.BakedModelRenderer;
import net.modificationstation.stationapi.api.client.render.model.BakedQuad;
import net.modificationstation.stationapi.api.client.render.model.ModelIdentifier;
import net.modificationstation.stationapi.api.client.render.model.ModelLoader;
import net.modificationstation.stationapi.api.client.render.model.json.ModelTransformation;
import net.modificationstation.stationapi.api.client.render.model.json.Transformation;
import net.modificationstation.stationapi.api.client.texture.StationTextureManager;
import net.modificationstation.stationapi.api.client.texture.atlas.Atlases;
import net.modificationstation.stationapi.api.registry.ItemRegistry;
import net.modificationstation.stationapi.api.util.Identifier;
import net.modificationstation.stationapi.api.util.Util;
import net.modificationstation.stationapi.api.util.crash.CrashException;
import net.modificationstation.stationapi.api.util.crash.CrashReport;
import net.modificationstation.stationapi.api.util.crash.CrashReportSection;
import net.modificationstation.stationapi.api.util.exception.CrashReportSectionBlockState;
import net.modificationstation.stationapi.api.util.math.Direction;
import net.modificationstation.stationapi.api.util.math.MathHelper;
import net.modificationstation.stationapi.impl.client.arsenic.renderer.aocalc.LightingCalculatorImpl;
import net.modificationstation.stationapi.impl.client.arsenic.renderer.render.BlockRenderContext;
import net.modificationstation.stationapi.impl.client.arsenic.renderer.render.ItemRenderContext;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.opengl.GL11;

public class BakedModelRendererImpl
implements BakedModelRenderer {
    private static final Direction[] DIRECTIONS = (Direction[])Util.make(() -> {
        Direction[] originalValues = Direction.values();
        return Arrays.copyOf(originalValues, originalValues.length + 1);
    });
    private final class_67 tessellator = class_67.field_2054;
    private final LightingCalculatorImpl light = new LightingCalculatorImpl(3);
    private final Random random = new Random();
    private final ItemModels itemModels = (ItemModels)Util.make((Object)new ItemModels(StationRenderAPI.getBakedModelManager()), models -> {
        for (Identifier id : ItemRegistry.INSTANCE.getIds()) {
            models.putModel((class_124)ItemRegistry.INSTANCE.get(id), ModelIdentifier.of((Identifier)id, (String)"inventory"));
        }
        models.reloadModels();
    });
    private final BlockColors blockColors = StationRenderAPI.getBlockColors();
    private final ItemColors itemColors = StationRenderAPI.getItemColors();
    private final ThreadLocal<BlockRenderContext> BLOCK_CONTEXTS = ThreadLocal.withInitial(BlockRenderContext::new);
    private final ThreadLocal<ItemRenderContext> ITEM_CONTEXTS = ThreadLocal.withInitial(() -> new ItemRenderContext(this.itemColors));
    private boolean damage;

    public boolean renderBlock(BlockState state, class_339 pos, class_14 world, boolean cull, Random random) {
        try {
            return this.render(world, StationRenderAPI.getBakedModelManager().getBlockModels().getModel(state), state, pos, cull, random, state.getRenderingSeed(pos));
        }
        catch (Throwable throwable) {
            CrashReport crashReport = CrashReport.create((Throwable)throwable, (String)"Tesselating block in world");
            CrashReportSection crashReportSection = crashReport.addElement("Block being tesselated");
            CrashReportSectionBlockState.addBlockInfo((CrashReportSection)crashReportSection, (class_14)world, (class_339)pos, (BlockState)state);
            throw new CrashException(crashReport);
        }
    }

    public boolean render(class_14 world, BakedModel model, BlockState state, class_339 pos, boolean cull, Random random, long seed) {
        boolean rendered = false;
        if (!(model = Objects.requireNonNull(model.getOverrides().apply(model, state, world, pos, (int)seed))).isVanillaAdapter()) {
            rendered = this.BLOCK_CONTEXTS.get().render(world, model, state, pos, random, seed);
        } else {
            class_17 block = state.getBlock();
            this.light.initialize(block, world, pos.field_2100, pos.field_2101, pos.field_2102, Minecraft.method_2148() && model.useAmbientOcclusion());
            float[] qlight = this.light.light;
            int size = DIRECTIONS.length;
            for (int quadSet = 0; quadSet < size; ++quadSet) {
                Direction face = DIRECTIONS[quadSet];
                random.setSeed(seed);
                ImmutableList qs = model.getQuads(state, face, random);
                if (qs.isEmpty() || face != null && !block.method_1618(world, pos.field_2100 + face.getOffsetX(), pos.field_2101 + face.getOffsetY(), pos.field_2102 + face.getOffsetZ(), quadSet)) continue;
                rendered = true;
                int quadSize = qs.size();
                for (int j = 0; j < quadSize; ++j) {
                    BakedQuad q = (BakedQuad)qs.get(j);
                    this.light.calculateForQuad(q);
                    this.renderQuad(world, state, pos, q, qlight);
                }
            }
        }
        return rendered;
    }

    private float redI2F(int color) {
        return (float)(color >> 16 & 0xFF) / 255.0f;
    }

    private float greenI2F(int color) {
        return (float)(color >> 8 & 0xFF) / 255.0f;
    }

    private float blueI2F(int color) {
        return (float)(color & 0xFF) / 255.0f;
    }

    private int colorF2I(float r, float g, float b) {
        int ri = this.colorChannelF2I(r);
        int gi = this.colorChannelF2I(g);
        int bi = this.colorChannelF2I(b);
        return ByteOrder.nativeOrder() == ByteOrder.LITTLE_ENDIAN ? 0xFF000000 | bi << 16 | gi << 8 | ri : ri << 24 | gi << 16 | bi << 8 | 0xFF;
    }

    private int colorChannelF2I(float colorChannel) {
        return Ints.constrainToRange((int)((int)(colorChannel * 255.0f)), (int)0, (int)255);
    }

    public void renderDamage(BlockState state, class_339 pos, class_14 world, float progress) {
        BakedModel bakedModel = StationRenderAPI.getBakedModelManager().getBlockModels().getModel(state);
        long l = state.getRenderingSeed(pos);
        this.damage = true;
        StationTextureManager.get((class_76)((Minecraft)FabricLoader.getInstance().getGameInstance()).field_2814).getTexture((Identifier)ModelLoader.BLOCK_DESTRUCTION_STAGE_TEXTURES.get((int)(progress * 10.0f))).bindTexture();
        this.render(world, bakedModel, state, pos, true, this.random, l);
        this.damage = false;
    }

    private void renderQuad(class_14 world, BlockState state, class_339 pos, BakedQuad quad, float[] brightness) {
        if (quad.hasColor()) {
            int i = this.blockColors.getColor(state, world, pos, quad.getColorIndex());
            float r = this.redI2F(i);
            float g = this.greenI2F(i);
            float b = this.blueI2F(i);
            this.tessellator.quad(quad, (float)pos.field_2100, (float)pos.field_2101, (float)pos.field_2102, this.colorF2I(r * brightness[0], g * brightness[0], b * brightness[0]), this.colorF2I(r * brightness[1], g * brightness[1], b * brightness[1]), this.colorF2I(r * brightness[2], g * brightness[2], b * brightness[2]), this.colorF2I(r * brightness[3], g * brightness[3], b * brightness[3]), 0.0f, 0.0f, 0.0f, this.damage);
        } else {
            this.tessellator.quad(quad, (float)pos.field_2100, (float)pos.field_2101, (float)pos.field_2102, this.colorF2I(brightness[0], brightness[0], brightness[0]), this.colorF2I(brightness[1], brightness[1], brightness[1]), this.colorF2I(brightness[2], brightness[2], brightness[2]), this.colorF2I(brightness[3], brightness[3], brightness[3]), 0.0f, 0.0f, 0.0f, this.damage);
        }
    }

    public ItemModels getItemModels() {
        return this.itemModels;
    }

    private void renderBakedItemModel(BakedModel model, class_31 stack, float brightness) {
        for (Direction direction : Direction.values()) {
            this.random.setSeed(42L);
            this.renderBakedItemQuads((List<BakedQuad>)model.getQuads(null, direction, this.random), stack, brightness);
        }
        this.random.setSeed(42L);
        this.renderBakedItemQuads((List<BakedQuad>)model.getQuads(null, null, this.random), stack, brightness);
    }

    private void renderBakedItemModelFlat(BakedModel model, class_31 stack, float brightness) {
        this.random.setSeed(42L);
        boolean bl = stack != null && stack.field_753 != 0 && stack.field_751 > 0;
        for (BakedQuad bakedQuad : model.getQuads(null, null, this.random)) {
            if (bakedQuad.getFace() != Direction.WEST) continue;
            int i = bl && bakedQuad.hasColor() ? this.itemColors.getColor(stack, bakedQuad.getColorIndex()) : -1;
            float light = MathHelper.lerp((double)bakedQuad.getEmission(), (float)brightness, (float)1.0f);
            i = this.colorF2I(this.redI2F(i) * light, this.greenI2F(i) * light, this.blueI2F(i) * light);
            this.tessellator.quad(bakedQuad, 0.0f, 0.0f, 0.0f, i, i, i, i, 0.0f, 1.0f, 0.0f, false);
        }
    }

    public void renderItem(class_31 stack, ModelTransformation.Mode renderMode, float brightness, BakedModel model) {
        if (stack == null || stack.field_753 == 0) {
            return;
        }
        if (model.isVanillaAdapter()) {
            float angle;
            Transformation transformation = model.getTransformation().getTransformation(renderMode);
            transformation.apply();
            boolean side = model.isSideLit();
            if (side && renderMode == ModelTransformation.Mode.GUI && (angle = transformation.rotation.getY() - 315.0f) != 0.0f) {
                class_583.method_1927();
                GL11.glPushMatrix();
                GL11.glRotatef((float)angle, (float)0.0f, (float)1.0f, (float)0.0f);
                class_583.method_1930();
                GL11.glPopMatrix();
            }
            GL11.glTranslatef((float)-0.5f, (float)-0.5f, (float)-0.5f);
            if (model.isBuiltin()) {
                return;
            }
            if (!side && renderMode == ModelTransformation.Mode.GROUND) {
                this.renderBakedItemModelFlat(model, stack, brightness);
            } else {
                this.renderBakedItemModel(model, stack, brightness);
            }
        } else {
            this.ITEM_CONTEXTS.get().renderModel(stack, renderMode, model, this::renderBakedItemModel);
        }
    }

    private void renderBakedItemQuads(List<BakedQuad> quads, class_31 stack, float brightness) {
        boolean bl = stack != null && stack.field_753 != 0 && stack.field_751 > 0;
        for (BakedQuad bakedQuad : quads) {
            int i = bl && bakedQuad.hasColor() ? this.itemColors.getColor(stack, bakedQuad.getColorIndex()) : -1;
            float light = MathHelper.lerp((double)bakedQuad.getEmission(), (float)brightness, (float)1.0f);
            i = this.colorF2I(this.redI2F(i) * light, this.greenI2F(i) * light, this.blueI2F(i) * light);
            Direction face = bakedQuad.getFace();
            this.tessellator.quad(bakedQuad, 0.0f, 0.0f, 0.0f, i, i, i, i, (float)face.getOffsetX(), (float)face.getOffsetY(), (float)face.getOffsetZ(), false);
        }
    }

    public BakedModel getModel(class_31 stack, @Nullable class_18 world, @Nullable class_127 entity, int seed) {
        BakedModel bakedModel = this.itemModels.getModel(stack);
        class_454 clientWorld = world instanceof class_454 ? (class_454)world : null;
        BakedModel bakedModel2 = bakedModel.getOverrides().apply(bakedModel, stack, (class_14)clientWorld, entity, seed);
        return bakedModel2 == null ? this.itemModels.getModelManager().getMissingModel() : bakedModel2;
    }

    public void renderItem(@Nullable class_127 entity, class_31 item, ModelTransformation.Mode renderMode, @Nullable class_18 world, float brightness, int seed) {
        if (item == null || item.field_753 == 0 || item.field_751 < 1) {
            return;
        }
        BakedModel bakedModel = this.getModel(item, world, entity, seed);
        this.renderItem(item, renderMode, brightness, bakedModel);
    }

    protected void renderGuiItemModel(class_31 stack, int x, int y, BakedModel model) {
        boolean flat;
        StationRenderAPI.getBakedModelManager().getAtlas(Atlases.GAME_ATLAS_TEXTURE).setFilter(false, false);
        GL11.glPushMatrix();
        GL11.glTranslated((double)x, (double)y, (double)14.5);
        GL11.glTranslatef((float)8.0f, (float)8.0f, (float)0.0f);
        GL11.glScalef((float)1.0f, (float)-1.0f, (float)1.0f);
        GL11.glScalef((float)16.0f, (float)16.0f, (float)16.0f);
        boolean bl = flat = !model.isSideLit();
        if (flat) {
            GL11.glDisable((int)2896);
        }
        this.tessellator.method_1695();
        this.renderItem(stack, ModelTransformation.Mode.GUI, 1.0f, model);
        this.tessellator.method_1685();
        if (flat) {
            GL11.glEnable((int)2896);
        }
        GL11.glPopMatrix();
        if (!flat) {
            class_583.method_1927();
            GL11.glPushMatrix();
            GL11.glRotatef((float)120.0f, (float)1.0f, (float)0.0f, (float)0.0f);
            class_583.method_1930();
            GL11.glPopMatrix();
        }
        GL11.glEnable((int)2884);
    }

    public void renderInGuiWithOverrides(class_31 stack, int x, int y) {
        this.innerRenderInGui((class_127)((Minecraft)FabricLoader.getInstance().getGameInstance()).field_2806, stack, x, y, 0);
    }

    private void innerRenderInGui(@Nullable class_127 entity, class_31 stack, int x, int y, int seed) {
        if (stack == null || stack.field_753 == 0 || stack.field_751 < 1) {
            return;
        }
        BakedModel bakedModel = this.getModel(stack, null, entity, seed);
        try {
            this.renderGuiItemModel(stack, x, y, bakedModel);
        }
        catch (Throwable throwable) {
            CrashReport crashReport = CrashReport.create((Throwable)throwable, (String)"Rendering item");
            CrashReportSection crashReportSection = crashReport.addElement("Item being rendered");
            crashReportSection.add("Item Type", () -> String.valueOf(stack.method_694()));
            crashReportSection.add("Item Damage", () -> String.valueOf(stack.method_722()));
            crashReportSection.add("Item NBT", () -> String.valueOf(stack.getStationNbt()));
            throw new CrashException(crashReport);
        }
    }
}

