/*
 * Decompiled with CFR 0.152.
 */
package net.modificationstation.stationapi.impl.client.arsenic.renderer.render;

import java.util.List;
import java.util.Random;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.class_31;
import net.minecraft.class_67;
import net.modificationstation.stationapi.api.client.color.item.ItemColors;
import net.modificationstation.stationapi.api.client.render.RenderContext;
import net.modificationstation.stationapi.api.client.render.material.BlendMode;
import net.modificationstation.stationapi.api.client.render.mesh.Mesh;
import net.modificationstation.stationapi.api.client.render.mesh.MutableQuadView;
import net.modificationstation.stationapi.api.client.render.mesh.QuadEmitter;
import net.modificationstation.stationapi.api.client.render.model.BakedModel;
import net.modificationstation.stationapi.api.client.render.model.BakedQuad;
import net.modificationstation.stationapi.api.client.render.model.ModelHelper;
import net.modificationstation.stationapi.api.client.render.model.json.ModelTransformation;
import net.modificationstation.stationapi.api.util.math.Direction;
import net.modificationstation.stationapi.api.util.math.Matrix4f;
import net.modificationstation.stationapi.api.util.math.MatrixStack;
import net.modificationstation.stationapi.api.util.math.Vec3f;
import net.modificationstation.stationapi.impl.client.arsenic.renderer.ArsenicRenderer;
import net.modificationstation.stationapi.impl.client.arsenic.renderer.RenderMaterialImpl;
import net.modificationstation.stationapi.impl.client.arsenic.renderer.helper.ColorHelper;
import net.modificationstation.stationapi.impl.client.arsenic.renderer.mesh.EncodingFormat;
import net.modificationstation.stationapi.impl.client.arsenic.renderer.mesh.MeshImpl;
import net.modificationstation.stationapi.impl.client.arsenic.renderer.mesh.MutableQuadViewImpl;
import net.modificationstation.stationapi.impl.client.arsenic.renderer.render.AbstractQuadRenderer;
import net.modificationstation.stationapi.impl.client.arsenic.renderer.render.AbstractRenderContext;

public class ItemRenderContext
extends AbstractRenderContext {
    private static final long ITEM_RANDOM_SEED = 42L;
    private final ItemColors colorMap;
    private final Random random = new Random();
    private final Consumer<BakedModel> fallbackConsumer;
    private final Vec3f normalVec = new Vec3f();
    private MatrixStack matrixStack;
    private Matrix4f matrix;
    private class_67 modelVertexConsumer;
    private BlendMode quadBlendMode;
    private class_67 quadVertexConsumer;
    private ModelTransformation.Mode transformMode;
    private float brightness;
    private int lightmap;
    private int overlay;
    private class_31 itemStack;
    private VanillaQuadHandler vanillaHandler;
    private final Supplier<Random> randomSupplier = () -> {
        this.random.setSeed(42L);
        return this.random;
    };
    private final int[] quadData = new int[EncodingFormat.TOTAL_STRIDE];
    private final Maker editorQuad = new Maker();
    private final Consumer<Mesh> meshConsumer = mesh -> {
        MeshImpl m = (MeshImpl)mesh;
        int[] data = m.data();
        int limit = data.length;
        for (int index = 0; index < limit; index += EncodingFormat.TOTAL_STRIDE) {
            System.arraycopy(data, index, this.editorQuad.data(), 0, EncodingFormat.TOTAL_STRIDE);
            this.editorQuad.load();
            this.renderQuad();
        }
    };

    public ItemRenderContext(ItemColors colorMap) {
        this.colorMap = colorMap;
        this.fallbackConsumer = this::fallbackConsumer;
    }

    public void renderModel(class_31 itemStack, ModelTransformation.Mode transformMode, BakedModel model, VanillaQuadHandler vanillaHandler) {
        this.itemStack = itemStack;
        this.transformMode = transformMode;
        this.vanillaHandler = vanillaHandler;
        this.quadBlendMode = BlendMode.DEFAULT;
        this.matrixStack.push();
        model.getTransformation().getTransformation(transformMode).apply();
        this.matrixStack.translate(-0.5, -0.5, -0.5);
        this.matrix = this.matrixStack.peek().getPositionMatrix();
        this.normalMatrix = this.matrixStack.peek().getNormalMatrix();
        model.emitItemQuads(itemStack, this.randomSupplier, (RenderContext)this);
        this.matrixStack.pop();
        this.matrixStack = null;
        this.itemStack = null;
        this.vanillaHandler = null;
        this.modelVertexConsumer = null;
    }

    private int indexColor() {
        int colorIndex = this.editorQuad.colorIndex();
        return colorIndex == -1 ? -1 : this.colorMap.getColor(this.itemStack, colorIndex) | 0xFF000000;
    }

    private void renderQuad() {
        Maker quad = this.editorQuad;
        if (!this.transform((MutableQuadView)this.editorQuad)) {
            return;
        }
        RenderMaterialImpl.Value mat = quad.material();
        int quadColor = mat.disableColorIndex(0) ? -1 : this.indexColor();
        int lightmap = mat.emissive(0) ? 0xF000F0 : this.lightmap;
        for (int i = 0; i < 4; ++i) {
            int c = quad.spriteColor(i, 0);
            c = ColorHelper.multiplyColour(quadColor, c);
            quad.spriteColor(i, 0, ColorHelper.swapRedBlueIfNeeded(c));
        }
        AbstractQuadRenderer.bufferQuad(this.quadVertexConsumer(mat.blendMode(0)), quad, this.matrix, this.overlay, this.normalMatrix, this.normalVec);
    }

    private class_67 quadVertexConsumer(BlendMode blendMode) {
        this.quadVertexConsumer = this.modelVertexConsumer;
        return this.quadVertexConsumer;
    }

    public Consumer<Mesh> meshConsumer() {
        return this.meshConsumer;
    }

    private void fallbackConsumer(BakedModel model) {
        if (this.hasTransform()) {
            for (int i = 0; i <= 6; ++i) {
                this.random.setSeed(42L);
                Direction cullFace = ModelHelper.faceFromIndex((int)i);
                this.renderFallbackWithTransform((List<BakedQuad>)model.getQuads(null, cullFace, this.random), cullFace);
            }
        } else {
            for (int i = 0; i <= 6; ++i) {
                this.vanillaHandler.accept(model, this.itemStack, this.brightness);
            }
        }
    }

    private void renderFallbackWithTransform(List<BakedQuad> quads, Direction cullFace) {
        if (quads.isEmpty()) {
            return;
        }
        Maker editorQuad = this.editorQuad;
        for (BakedQuad q : quads) {
            editorQuad.fromVanilla(q, ArsenicRenderer.MATERIAL_STANDARD, cullFace);
            this.renderQuad();
        }
    }

    public Consumer<BakedModel> fallbackConsumer() {
        return this.fallbackConsumer;
    }

    public QuadEmitter getEmitter() {
        this.editorQuad.clear();
        return this.editorQuad;
    }

    private class Maker
    extends MutableQuadViewImpl
    implements QuadEmitter {
        private Maker() {
            this.data = ItemRenderContext.this.quadData;
            this.clear();
        }

        public Maker emit() {
            this.computeGeometry();
            ItemRenderContext.this.renderQuad();
            this.clear();
            return this;
        }
    }

    @FunctionalInterface
    public static interface VanillaQuadHandler {
        public void accept(BakedModel var1, class_31 var2, float var3);
    }
}

