/*
 * Decompiled with CFR 0.152.
 */
package net.modificationstation.stationapi.api.client.resource;

import com.google.common.primitives.Floats;
import com.google.common.primitives.Longs;
import cyclops.control.Option;
import cyclops.function.Effect;
import cyclops.function.FluentFunctions;
import it.unimi.dsi.fastutil.doubles.Double2DoubleFunction;
import it.unimi.dsi.fastutil.longs.Long2DoubleFunction;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.CompletionException;
import java.util.function.BooleanSupplier;
import java.util.function.Function;
import java.util.function.LongSupplier;
import java.util.function.ToDoubleFunction;
import java.util.function.UnaryOperator;
import net.minecraft.class_189;
import net.minecraft.class_32;
import net.minecraft.class_34;
import net.minecraft.class_67;
import net.modificationstation.stationapi.api.StationAPI;
import net.modificationstation.stationapi.api.client.resource.ReloadScreenManager;
import net.modificationstation.stationapi.api.resource.ResourceReload;
import net.modificationstation.stationapi.api.util.math.ColorHelper;
import net.modificationstation.stationapi.api.util.math.MathHelper;
import net.modificationstation.stationapi.impl.client.resource.ReloadScreenManagerImpl;
import org.lwjgl.opengl.GL11;

class ReloadScreen
extends class_32 {
    private static final long MAX_FPS = 60L;
    private static final long BACKGROUND_START = 0L;
    private static final long BACKGROUND_FADE_IN = 1000L;
    private static final long STAGE_0_START = 1000L;
    private static final long STAGE_0_FADE_IN = 2000L;
    private static final long GLOBAL_FADE_OUT = 1000L;
    private static final long RELOAD_START = 3000L;
    private static final long EXCEPTION_TRANSFORM = 500L;
    private static final int BACKGROUND_COLOR_DEFAULT_RED = 53;
    private static final int BACKGROUND_COLOR_DEFAULT_GREEN = 134;
    private static final int BACKGROUND_COLOR_DEFAULT_BLUE = 231;
    private static final int BACKGROUND_COLOR_EXCEPTION_RED = 255;
    private static final int BACKGROUND_COLOR_EXCEPTION_GREEN = 41;
    private static final int BACKGROUND_COLOR_EXCEPTION_BLUE = 41;
    private static final Object BACKGROUND_DEFAULT_DELTA_KEY = new Object();
    private static final Object BACKGROUND_EXCEPTION_DELTA_KEY = new Object();
    private static final Object STAGE_0_DEFAULT_DELTA_KEY = new Object();
    private static final Object STAGE_0_EXCEPTION_DELTA_KEY = new Object();
    private static final Double2DoubleFunction SIN_90_DELTA = delta -> class_189.method_644((float)((float)(delta * Math.PI / 2.0)));
    private static final Double2DoubleFunction COS_90_DELTA = delta -> class_189.method_646((float)((float)(delta * Math.PI / 2.0)));
    private static final Double2DoubleFunction INVERSE_DELTA = delta -> 1.0 - delta;
    private static final Long2DoubleFunction BACKGROUND_FADE_IN_DELTA = time -> (double)Longs.constrainToRange((long)(time - 0L), (long)0L, (long)1000L) / 1000.0;
    private static final Long2DoubleFunction STAGE_0_FADE_IN_DELTA = time -> (double)Longs.constrainToRange((long)(time - 1000L), (long)0L, (long)2000L) / 2000.0;
    private static final Function<LongSupplier, Long2DoubleFunction> GLOBAL_FADE_OUT_DELTA_FACTORY = fadeOutStartGetter -> INVERSE_DELTA.composeLong(time -> (double)Longs.constrainToRange((long)(time - fadeOutStartGetter.getAsLong()), (long)0L, (long)1000L) / 1000.0);
    private static final Function<LongSupplier, Long2DoubleFunction> BACKGROUND_EXCEPTION_FADE_IN_FACTORY = fadeInStartGetter -> time -> (double)Longs.constrainToRange((long)(time - fadeInStartGetter.getAsLong()), (long)0L, (long)500L) / 500.0;
    private static final Function<LongSupplier, Long2DoubleFunction> STAGE_0_EXCEPTION_TRANSFORM_FACTORY = transformStartGetter -> time -> (double)Longs.constrainToRange((long)(time - transformStartGetter.getAsLong()), (long)0L, (long)500L) / 500.0;
    private static final String LOGO_TEMPLATE = "/assets/station-resource-loader-v0/textures/gui/stationapi_reload%s.png";
    private final class_32 parent;
    private final Runnable done;
    private final class_67 tessellator;
    private boolean firstRenderTick = true;
    private long initTimestamp;
    private long currentTime;
    private float progress;
    private final Effect backgroundEmitter;
    private final Effect stage0Emitter;
    private boolean finished;
    private long fadeOutStart;
    private float scrollProgress;
    private final String logo;
    private boolean exceptionThrown;
    private long exceptionStart;
    private Exception exception;
    private long lastRender;

    private static UnaryOperator<Long2DoubleFunction> when(BooleanSupplier condition, Long2DoubleFunction ifTrue) {
        return ifFalse -> value -> (condition.getAsBoolean() ? ifTrue : ifFalse).applyAsDouble(value);
    }

    ReloadScreen(class_32 parent, Runnable done, class_67 tessellator) {
        ReloadScreenManager.reloadScreen = this;
        this.parent = parent;
        this.done = done;
        this.tessellator = tessellator;
        Object[] objectArray = new Object[1];
        objectArray[0] = switch (new Random().nextInt(100)) {
            case 0 -> "_dimando";
            case 1 -> "_old";
            default -> "";
        };
        this.logo = LOGO_TEMPLATE.formatted(objectArray);
        UnaryOperator<Long2DoubleFunction> globalFadeOutComposer = ReloadScreen.when(() -> this.finished, GLOBAL_FADE_OUT_DELTA_FACTORY.apply(() -> this.fadeOutStart));
        Map<Object, Long2DoubleFunction> deltaMap = Map.of(BACKGROUND_DEFAULT_DELTA_KEY, ((Long2DoubleFunction)globalFadeOutComposer.apply(BACKGROUND_FADE_IN_DELTA)).andThenDouble(SIN_90_DELTA), BACKGROUND_EXCEPTION_DELTA_KEY, BACKGROUND_EXCEPTION_FADE_IN_FACTORY.apply(() -> this.exceptionStart).andThenDouble(COS_90_DELTA).andThenDouble(INVERSE_DELTA), STAGE_0_DEFAULT_DELTA_KEY, ((Long2DoubleFunction)globalFadeOutComposer.apply(STAGE_0_FADE_IN_DELTA)).andThenDouble(SIN_90_DELTA), STAGE_0_EXCEPTION_DELTA_KEY, STAGE_0_EXCEPTION_TRANSFORM_FACTORY.apply(() -> this.exceptionStart).andThenDouble(COS_90_DELTA));
        ToDoubleFunction<Object> deltaFunc = key -> ((Long2DoubleFunction)deltaMap.get(key)).applyAsDouble(this.currentTime);
        this.backgroundEmitter = () -> ((FluentFunctions.FluentSupplier)FluentFunctions.expression(this::renderBackground).partiallyApply(deltaFunc)).get();
        this.stage0Emitter = () -> ((FluentFunctions.FluentSupplier)FluentFunctions.expression(this::renderProgressBar).before(this::renderLogo).partiallyApply(deltaFunc)).get();
    }

    private void renderBackground(ToDoubleFunction<Object> deltaFunc) {
        int color;
        double delta = deltaFunc.applyAsDouble(BACKGROUND_DEFAULT_DELTA_KEY);
        if (this.exceptionThrown) {
            double exceptionDelta = deltaFunc.applyAsDouble(BACKGROUND_EXCEPTION_DELTA_KEY);
            color = ColorHelper.Argb.getArgb((int)255, (int)MathHelper.lerp((double)exceptionDelta, (int)53, (int)255), (int)MathHelper.lerp((double)exceptionDelta, (int)134, (int)41), (int)MathHelper.lerp((double)exceptionDelta, (int)231, (int)41));
        } else {
            color = this.parent == null ? (this.finished ? ColorHelper.Argb.getArgb((int)255, (int)MathHelper.lerp((double)delta, (int)255, (int)53), (int)MathHelper.lerp((double)delta, (int)255, (int)134), (int)MathHelper.lerp((double)delta, (int)255, (int)231)) : ColorHelper.Argb.getArgb((int)255, (int)((int)(delta * 53.0)), (int)((int)(delta * 134.0)), (int)((int)(delta * 231.0)))) : ColorHelper.Argb.getArgb((int)((int)(delta * 255.0)), (int)53, (int)134, (int)231);
        }
        this.method_1932(0, 0, this.field_152, this.field_153, color);
    }

    private void renderProgressBar(ToDoubleFunction<Object> deltaFunc) {
        double delta = deltaFunc.applyAsDouble(STAGE_0_DEFAULT_DELTA_KEY);
        if (delta == 0.0) {
            return;
        }
        int color = (int)(delta * 255.0) << 24 | 0xFFFFFF;
        float v = (float)(10.0 - delta * 10.0);
        float ev = this.exceptionThrown ? (float)(10.0 - deltaFunc.applyAsDouble(STAGE_0_EXCEPTION_DELTA_KEY) * 10.0) * 3.0f - 1.0f : 0.0f;
        this.method_1931(40, this.field_152 - 40 - 1, (int)((float)(this.field_153 - 90) + v * 5.0f), color);
        if (this.exceptionThrown) {
            this.method_1931(40, this.field_152 - 40 - 1, (int)((float)(this.field_153 - 90) + v * 5.0f + ev), color);
        }
        this.method_1931(40, this.field_152 - 40 - 1, (int)((float)(this.field_153 - 50) + v), color);
        this.method_1931(40, this.field_152 - 40 - 1, (int)((float)(this.field_153 - 40 - 1) + v), color);
        this.method_1935(40, (int)((float)(this.field_153 - 40) + v), (int)((float)(this.field_153 - 90) + v * 5.0f), color);
        this.method_1935(this.field_152 - 40 - 1, (int)((float)(this.field_153 - 40) + v), (int)((float)(this.field_153 - 90) + v * 5.0f), color);
        this.method_1932(43, (int)((float)(this.field_153 - 50 + 3) + v), MathHelper.ceil((float)((float)(this.field_152 - 86) * this.progress + 40.0f + 3.0f)), (int)((float)(this.field_153 - 40 - 3) + v), color);
        float xScale = (float)this.field_151.field_2802 / (float)this.field_152;
        float yScale = (float)this.field_151.field_2803 / (float)this.field_153;
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        int locationsScissorsHeight = (int)((39.0f - v * 4.0f + ev) * yScale);
        if (locationsScissorsHeight > 0) {
            int y;
            int to = MathHelper.ceil((float)this.scrollProgress);
            float scrollDelta = this.scrollProgress - (float)to;
            GL11.glEnable((int)3089);
            GL11.glScissor((int)((int)(43.0f * xScale)), (int)((int)((50.0f - v) * yScale)), (int)((int)((float)(this.field_152 - 86) * xScale)), (int)locationsScissorsHeight);
            for (int i = 0; i < to && !((float)(y = MathHelper.ceil((float)((float)(this.field_153 - 88 + 10 * i) + scrollDelta * 10.0f + v * 5.0f + ev))) > (float)(this.field_153 - 50) + v); ++i) {
                this.method_1937(this.field_156, ReloadScreenManager.LOCATIONS.get(to - i - 1), 43, y, color);
            }
            GL11.glDisable((int)3089);
        }
        int exceptionScissorsHeight = (int)((-1.0f - v * 4.0f + ev) * yScale);
        if (this.exceptionThrown && exceptionScissorsHeight > 0) {
            GL11.glEnable((int)3089);
            GL11.glScissor((int)((int)(43.0f * xScale)), (int)((int)((91.0f - v - ev) * yScale)), (int)((int)((float)(this.field_152 - 86) * xScale)), (int)exceptionScissorsHeight);
            String line = this.exception.getMessage();
            int curHeight = this.field_153 - 88;
            int lineWidth = this.field_156.method_1901(line);
            if (lineWidth > this.field_152 - 86) {
                int begin = 0;
                int lastSpace = -1;
                int lineLength = line.length();
                for (int cur = 0; cur < lineLength; ++cur) {
                    boolean isEnd;
                    boolean isSpace = line.charAt(cur) == ' ';
                    boolean bl = isEnd = cur + 1 == lineLength;
                    if (!isSpace && !isEnd) continue;
                    String newLine = isEnd ? line.substring(begin) : line.substring(begin, cur);
                    int newLineWidth = this.field_156.method_1901(newLine);
                    if (newLineWidth > this.field_152 - 86) {
                        this.method_1937(this.field_156, line.substring(begin, lastSpace), 43, curHeight, color);
                        curHeight += 10;
                        begin = lastSpace + 1;
                    }
                    if (isSpace) {
                        lastSpace = cur;
                    }
                    if (!isEnd) continue;
                    this.method_1937(this.field_156, line.substring(begin), 43, curHeight, color);
                    curHeight += 10;
                }
            } else {
                this.method_1937(this.field_156, line, 43, curHeight, color);
            }
            GL11.glDisable((int)3089);
        }
        this.method_1937(this.field_156, "Minecraft: " + (ReloadScreenManagerImpl.isMinecraftDone ? "Done" : "Working..."), 43, (int)((float)(this.field_153 - 100) + v * 5.0f), color);
        String stationStatus = "StationAPI: " + (this.isReloadStarted() ? (ReloadScreenManager.isReloadComplete() ? "Done" : "Working...") : "Idle");
        this.method_1937(this.field_156, stationStatus, this.field_152 - 40 - 3 - this.field_156.method_1901(stationStatus), (int)((float)(this.field_153 - 100) + v * 5.0f), color);
        GL11.glDisable((int)3042);
    }

    private void renderLogo(ToDoubleFunction<Object> deltaFunc) {
        double delta = deltaFunc.applyAsDouble(STAGE_0_DEFAULT_DELTA_KEY);
        if (delta == 0.0) {
            return;
        }
        double v = 10.0 - delta * 10.0;
        this.field_151.field_2814.method_1097(this.field_151.field_2814.method_1100(this.logo));
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        this.tessellator.method_1695();
        this.tessellator.method_1694(255, 255, 255, (int)(255.0 * delta));
        this.tessellator.method_1688((double)this.field_152 / 2.0 - 120.0, ((double)this.field_153 - 90.0) / 2.0 - 20.0 - v, 0.0, 0.0, 0.0);
        this.tessellator.method_1688((double)this.field_152 / 2.0 - 120.0, ((double)this.field_153 - 90.0) / 2.0 + 20.0 - v, 0.0, 0.0, 1.0);
        this.tessellator.method_1688((double)this.field_152 / 2.0 + 120.0, ((double)this.field_153 - 90.0) / 2.0 + 20.0 - v, 0.0, 1.0, 1.0);
        this.tessellator.method_1688((double)this.field_152 / 2.0 + 120.0, ((double)this.field_153 - 90.0) / 2.0 - 20.0 - v, 0.0, 1.0, 0.0);
        this.tessellator.method_1685();
        GL11.glDisable((int)3042);
    }

    public void method_134() {
        this.backgroundEmitter.run();
    }

    public void method_118(int mouseX, int mouseY, float delta) {
        boolean partial;
        if (this.firstRenderTick) {
            this.firstRenderTick = false;
            this.initTimestamp = System.currentTimeMillis();
        }
        this.currentTime = System.currentTimeMillis() - this.initTimestamp;
        boolean bl = partial = this.currentTime - this.lastRender < 16L;
        if (partial) {
            this.currentTime = this.lastRender;
        } else {
            this.lastRender = this.currentTime;
        }
        int locationsSize = ReloadScreenManager.LOCATIONS.size();
        if (!(this.exceptionThrown || this.finished || (double)this.scrollProgress + 0.1 < (double)locationsSize || (double)this.progress + 0.1 < 1.0 || !ReloadScreenManager.isReloadComplete())) {
            try {
                ReloadScreenManager.getCurrentReload().peek(ResourceReload::throwException);
                this.finished = true;
                this.fadeOutStart = this.currentTime;
            }
            catch (CompletionException e) {
                this.exceptionThrown = true;
                this.exceptionStart = this.currentTime;
                this.exception = e;
                StationAPI.LOGGER.error("An exception occurred during resource loading", (Throwable)e);
            }
        }
        if (!partial) {
            Option<ResourceReload> reload;
            this.progress = Floats.constrainToRange((float)(this.progress * 0.95f + (this.isReloadStarted() && (reload = ReloadScreenManager.getCurrentReload()).isPresent() ? ((ResourceReload)reload.orElse(null)).getProgress() : 0.0f) * 0.05f), (float)0.0f, (float)1.0f);
            this.scrollProgress = Floats.constrainToRange((float)(this.scrollProgress * 0.95f + (float)locationsSize * 0.05f), (float)0.0f, (float)locationsSize);
        }
        if ((this.finished ? this.currentTime <= this.fadeOutStart + 1000L : this.currentTime < 1000L) && this.parent != null) {
            this.parent.method_118(mouseX, mouseY, delta);
        }
        this.method_134();
        super.method_118(mouseX, mouseY, delta);
        this.stage0Emitter.run();
        if (this.finished && this.currentTime - this.fadeOutStart > 1000L) {
            ReloadScreenManager.onFinish();
            this.done.run();
        }
    }

    boolean isReloadStarted() {
        return this.currentTime > 3000L;
    }

    protected void method_1931(int startX, int endX, int y, int color) {
        if (endX < startX) {
            int n = startX;
            startX = endX;
            endX = n;
        }
        this.method_1932(startX, y, endX + 1, y + 1, color);
    }

    protected void method_1935(int x, int startY, int endY, int color) {
        if (endY < startY) {
            int n = startY;
            startY = endY;
            endY = n;
        }
        this.method_1932(x, startY + 1, x + 1, endY, color);
    }

    protected void method_1932(int startX, int startY, int endX, int endY, int color) {
        int n;
        if (startX < endX) {
            n = startX;
            startX = endX;
            endX = n;
        }
        if (startY < endY) {
            n = startY;
            startY = endY;
            endY = n;
        }
        float a = (float)(color >> 24 & 0xFF) / 255.0f;
        float r = (float)(color >> 16 & 0xFF) / 255.0f;
        float g = (float)(color >> 8 & 0xFF) / 255.0f;
        float b = (float)(color & 0xFF) / 255.0f;
        GL11.glEnable((int)3042);
        GL11.glDisable((int)3553);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glColor4f((float)r, (float)g, (float)b, (float)a);
        this.tessellator.method_1695();
        this.tessellator.method_1687((double)startX, (double)endY, 0.0);
        this.tessellator.method_1687((double)endX, (double)endY, 0.0);
        this.tessellator.method_1687((double)endX, (double)startY, 0.0);
        this.tessellator.method_1687((double)startX, (double)startY, 0.0);
        this.tessellator.method_1685();
        GL11.glEnable((int)3553);
        GL11.glDisable((int)3042);
    }

    void setTextRenderer(class_34 textRenderer) {
        this.field_156 = textRenderer;
    }
}

