/*
 * Decompiled with CFR 0.152.
 */
package net.modificationstation.stationapi.api.client.resource;

import cyclops.control.Option;
import cyclops.function.FluentFunctions;
import cyclops.function.Function0;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicBoolean;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_32;
import net.minecraft.class_34;
import net.minecraft.class_559;
import net.minecraft.class_564;
import net.minecraft.class_67;
import net.minecraft.client.Minecraft;
import net.modificationstation.stationapi.api.client.resource.ReloadScreen;
import net.modificationstation.stationapi.api.resource.CompositeResourceReload;
import net.modificationstation.stationapi.api.resource.ResourceReload;
import net.modificationstation.stationapi.api.resource.ResourceReloader;
import net.modificationstation.stationapi.api.tick.TickScheduler;
import net.modificationstation.stationapi.api.util.profiler.ProfileResult;
import net.modificationstation.stationapi.impl.client.resource.ReloadScreenApplicationExecutor;
import net.modificationstation.stationapi.impl.client.resource.ReloadScreenManagerImpl;
import net.modificationstation.stationapi.impl.client.resource.ReloadScreenTessellatorHolder;
import net.modificationstation.stationapi.mixin.resourceloader.client.MinecraftAccessor;
import net.modificationstation.stationapi.mixin.resourceloader.client.TessellatorAccessor;
import org.jetbrains.annotations.NotNull;
import org.lwjgl.LWJGLException;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.Display;
import org.lwjgl.opengl.Drawable;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.SharedDrawable;

public class ReloadScreenManager {
    @NotNull
    private static Option<Thread> thread = Option.none();
    @NotNull
    private static Option<ResourceReload> currentReload = Option.none();
    static ReloadScreen reloadScreen;
    static final List<String> LOCATIONS;
    private static final Executor EMPTY_EXECUTOR;
    @NotNull
    private static Executor applicationExecutor;

    public static void pushLocation(String customLocation) {
        LOCATIONS.add(customLocation);
    }

    public static void pushLocation(ResourceReloader resourceReloader, String formatString, String location) {
        ReloadScreenManager.pushLocation(ProfileResult.getHumanReadableName((String)formatString.formatted(location.replaceAll("^root", resourceReloader.getName()))));
    }

    public static void openEarly() throws LWJGLException {
        ReloadScreenManagerImpl.isMinecraftDone = false;
        applicationExecutor = ReloadScreenApplicationExecutor.INSTANCE;
        currentReload = Option.some((Object)new CompositeResourceReload());
        thread = Option.some((Object)new Thread(() -> ((FluentFunctions.FluentSupplier)FluentFunctions.expression(ReloadScreenManager::onStartup).partiallyApply((Object)((Minecraft)FabricLoader.getInstance().getGameInstance()), (Object)new SharedDrawable(Display.getDrawable()))).get()));
        thread.peek(Thread::start);
    }

    public static void open() {
        applicationExecutor = arg_0 -> ((TickScheduler)TickScheduler.CLIENT_RENDER_END).distributed(arg_0);
        currentReload = Option.some((Object)new CompositeResourceReload());
        TickScheduler.CLIENT_RENDER_START.immediate(() -> {
            Minecraft minecraft = (Minecraft)FabricLoader.getInstance().getGameInstance();
            class_32 parentScreen = minecraft.field_2816;
            ReloadScreen reloadScreen = new ReloadScreen(parentScreen, () -> ((Function0)FluentFunctions.expression(arg_0 -> ((Minecraft)minecraft).method_2112(arg_0)).applyLazy((Object)parentScreen)).apply(), class_67.field_2054);
            minecraft.method_2112((class_32)reloadScreen);
        });
    }

    public static boolean isReloadStarted() {
        return reloadScreen != null && reloadScreen.isReloadStarted();
    }

    public static boolean isReloadComplete() {
        return ReloadScreenManager.isReloadStarted() && currentReload.isPresent() && ((ResourceReload)currentReload.orElse(null)).isComplete();
    }

    @NotNull
    public static Executor getApplicationExecutor() {
        return applicationExecutor;
    }

    static void onFinish() {
        reloadScreen = null;
        LOCATIONS.clear();
        applicationExecutor = EMPTY_EXECUTOR;
        currentReload = Option.none();
    }

    private static void onStartup(Minecraft minecraft, Drawable drawable) {
        try {
            drawable.makeCurrent();
        }
        catch (LWJGLException e) {
            throw new RuntimeException(e);
        }
        AtomicBoolean done = new AtomicBoolean();
        ReloadScreenTessellatorHolder.reloadScreenTessellator = TessellatorAccessor.stationapi_create(48);
        ReloadScreen reloadScreen = new ReloadScreen(minecraft.field_2816, () -> ((Function0)FluentFunctions.expression(done::set).applyLazy((Object)true)).apply(), ReloadScreenTessellatorHolder.reloadScreenTessellator);
        class_564 screenScaler = new class_564(minecraft.field_2824, minecraft.field_2802, minecraft.field_2803);
        int width = screenScaler.method_1857();
        int height = screenScaler.method_1858();
        reloadScreen.method_125(minecraft, width, height);
        reloadScreen.setTextRenderer(new class_34(minecraft.field_2824, "/font/default.png", minecraft.field_2814));
        class_559 timer = ((MinecraftAccessor)minecraft).getTimer();
        GL11.glClear((int)16640);
        GL11.glMatrixMode((int)5889);
        GL11.glLoadIdentity();
        GL11.glOrtho((double)0.0, (double)screenScaler.field_2389, (double)screenScaler.field_2390, (double)0.0, (double)1000.0, (double)3000.0);
        GL11.glMatrixMode((int)5888);
        GL11.glLoadIdentity();
        GL11.glTranslatef((float)0.0f, (float)0.0f, (float)-2000.0f);
        GL11.glViewport((int)0, (int)0, (int)minecraft.field_2802, (int)minecraft.field_2803);
        GL11.glClearColor((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f);
        GL11.glDisable((int)2896);
        GL11.glEnable((int)3553);
        GL11.glDisable((int)2912);
        while (!done.get()) {
            while (Mouse.next()) {
            }
            while (Keyboard.next()) {
            }
            float f = timer.field_2370;
            timer.method_1853();
            timer.field_2370 = f;
            int mouseX = Mouse.getX() * width / minecraft.field_2802;
            int mouseY = height - Mouse.getY() * height / minecraft.field_2803 - 1;
            reloadScreen.method_118(mouseX, mouseY, timer.field_2370);
            Display.update();
        }
        GL11.glDisable((int)2896);
        GL11.glDisable((int)2912);
        GL11.glEnable((int)3008);
        GL11.glAlphaFunc((int)516, (float)0.1f);
        try {
            drawable.releaseContext();
            drawable.destroy();
        }
        catch (LWJGLException e) {
            throw new RuntimeException(e);
        }
        thread = Option.none();
    }

    @NotNull
    public static Option<Thread> getThread() {
        return thread;
    }

    @NotNull
    public static Option<ResourceReload> getCurrentReload() {
        return currentReload;
    }

    static {
        LOCATIONS = new CopyOnWriteArrayList<String>();
        applicationExecutor = EMPTY_EXECUTOR = command -> {};
    }
}

