/*
 * Decompiled with CFR 0.152.
 */
package net.modificationstation.stationapi.api.resource;

import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import cyclops.control.Option;
import cyclops.data.tuple.Tuple;
import cyclops.data.tuple.Tuple2;
import cyclops.function.Function1;
import cyclops.function.Function2;
import it.unimi.dsi.fastutil.objects.Reference2ObjectMap;
import it.unimi.dsi.fastutil.objects.Reference2ObjectMaps;
import it.unimi.dsi.fastutil.objects.Reference2ObjectOpenHashMap;
import java.util.function.BiFunction;
import java.util.function.Function;
import net.modificationstation.stationapi.api.resource.ResourceReload;
import net.modificationstation.stationapi.api.util.Identifier;

public final class CompositeResourceReload
implements ResourceReload {
    private static final float DEFAULT_WEIGHT = 1.0f;
    private static final Function2<Function<Float, Float>, Tuple2<Option<Supplier<ResourceReload>>, Float>, Tuple2<Option<Supplier<ResourceReload>>, Float>> WEIGHT_MAPPER_FACTORY = Function2.\u03bb(Tuple2::map2).reverse();
    private static final Function2<Function<Option<Supplier<ResourceReload>>, Option<Supplier<ResourceReload>>>, Tuple2<Option<Supplier<ResourceReload>>, Float>, Tuple2<Option<Supplier<ResourceReload>>, Float>> RESOURCE_RELOAD_MAPPER_FACTORY = Function2.\u03bb(Tuple2::map1).reverse();
    private final Reference2ObjectMap<Identifier, Tuple2<Option<Supplier<ResourceReload>>, Float>> reloads = Reference2ObjectMaps.synchronize((Reference2ObjectMap)new Reference2ObjectOpenHashMap());

    public void setWeight(Identifier id, float weight) {
        this.reloads.merge((Object)id, (Object)Tuple.tuple((Object)Option.none(), (Object)Float.valueOf(weight)), (BiFunction)Function2._2((Function)WEIGHT_MAPPER_FACTORY.apply((Object)Function1.constant((Object)Float.valueOf(weight)))));
    }

    public void scheduleReload(Identifier id, Supplier<ResourceReload> reload) {
        this.reloads.merge((Object)id, (Object)Tuple.tuple((Object)Option.some((Object)Suppliers.memoize(reload)), (Object)Float.valueOf(1.0f)), (BiFunction)Function2._2((Function)RESOURCE_RELOAD_MAPPER_FACTORY.apply((Object)Function1.constant((Object)Option.some((Object)Suppliers.memoize(reload))))));
    }

    public void scheduleReload(Identifier id, Supplier<ResourceReload> reload, float weight) {
        this.reloads.put((Object)id, (Object)Tuple.tuple((Object)Option.some((Object)Suppliers.memoize(reload)), (Object)Float.valueOf(weight)));
    }

    @Override
    public float getProgress() {
        float totalWeight = 0.0f;
        float progress = 0.0f;
        for (Tuple2 weightedReload : this.reloads.values()) {
            totalWeight += ((Float)weightedReload._2()).floatValue();
            if (!((Option)weightedReload._1()).isPresent()) continue;
            progress += ((ResourceReload)((Supplier)((Option)weightedReload._1()).orElse(null)).get()).getProgress() * ((Float)weightedReload._2()).floatValue();
        }
        return progress / totalWeight;
    }

    @Override
    public boolean isComplete() {
        if (this.reloads.values().isEmpty()) {
            return false;
        }
        for (Tuple2 weightedReload : this.reloads.values()) {
            if (!((Option)weightedReload._1()).isPresent() || ((ResourceReload)((Supplier)((Option)weightedReload._1()).orElse(null)).get()).isComplete()) continue;
            return false;
        }
        return true;
    }

    @Override
    public void throwException() {
        for (Tuple2 weightedReload : this.reloads.values()) {
            if (!((Option)weightedReload._1()).isPresent()) continue;
            ((ResourceReload)((Supplier)((Option)weightedReload._1()).orElse(null)).get()).throwException();
        }
    }
}

