/*
 * Decompiled with CFR 0.152.
 */
package net.modificationstation.stationapi.api.resource;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import it.unimi.dsi.fastutil.objects.Reference2ReferenceOpenHashMap;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.Map;
import net.modificationstation.stationapi.api.StationAPI;
import net.modificationstation.stationapi.api.resource.Resource;
import net.modificationstation.stationapi.api.resource.ResourceFinder;
import net.modificationstation.stationapi.api.resource.ResourceManager;
import net.modificationstation.stationapi.api.resource.SinglePreparationResourceReloader;
import net.modificationstation.stationapi.api.util.Identifier;
import net.modificationstation.stationapi.api.util.JsonHelper;
import net.modificationstation.stationapi.api.util.profiler.Profiler;

public abstract class JsonDataLoader
extends SinglePreparationResourceReloader<Map<Identifier, JsonElement>> {
    private final Gson gson;
    private final String dataType;

    public JsonDataLoader(Gson gson, String dataType) {
        this.gson = gson;
        this.dataType = dataType;
    }

    @Override
    protected Map<Identifier, JsonElement> prepare(ResourceManager resourceManager, Profiler profiler) {
        Reference2ReferenceOpenHashMap result = new Reference2ReferenceOpenHashMap();
        ResourceFinder jsonFinder = ResourceFinder.json(this.dataType);
        for (Map.Entry<Identifier, Resource> found : jsonFinder.findResources(resourceManager).entrySet()) {
            Identifier path = found.getKey();
            Identifier id = jsonFinder.toResourceId(path);
            try {
                BufferedReader reader = found.getValue().getReader();
                try {
                    JsonElement element = (JsonElement)JsonHelper.deserialize((Gson)this.gson, (Reader)reader, JsonElement.class);
                    JsonElement previousElement = (JsonElement)result.put((Object)id, (Object)element);
                    if (previousElement == null) continue;
                    throw new IllegalStateException("Duplicate data file ignored with ID " + String.valueOf(id));
                }
                finally {
                    if (reader == null) continue;
                    reader.close();
                }
            }
            catch (JsonParseException | IOException | IllegalArgumentException exception) {
                StationAPI.LOGGER.error("Couldn't parse data file {} from {}", (Object)id, (Object)path, (Object)exception);
            }
        }
        return result;
    }
}

