/*
 * Decompiled with CFR 0.152.
 */
package net.modificationstation.stationapi.api.resource;

import com.google.common.base.Stopwatch;
import cyclops.function.Consumer3;
import cyclops.function.FluentFunctions;
import cyclops.function.Function0;
import cyclops.function.Function1;
import java.lang.invoke.LambdaMetafactory;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import net.modificationstation.stationapi.api.StationAPI;
import net.modificationstation.stationapi.api.resource.ResourceManager;
import net.modificationstation.stationapi.api.resource.ResourceReloader;
import net.modificationstation.stationapi.api.resource.ResourceType;
import net.modificationstation.stationapi.api.resource.SimpleResourceReload;
import net.modificationstation.stationapi.api.util.Unit;
import net.modificationstation.stationapi.api.util.Util;
import net.modificationstation.stationapi.api.util.profiler.ProfileResult;
import net.modificationstation.stationapi.api.util.profiler.Profiler;
import net.modificationstation.stationapi.api.util.profiler.ProfilerSystem;
import org.apache.commons.lang3.StringUtils;

public class ProfiledResourceReload
extends SimpleResourceReload<Summary> {
    private static final String LOCATION_FORMAT = "%s: %s (%s)";
    private final Stopwatch reloadTimer = Stopwatch.createUnstarted();

    public ProfiledResourceReload(ResourceManager manager, List<ResourceReloader> reloaders, Executor prepareExecutor, Executor applyExecutor, Consumer3<ResourceReloader, String, String> profilerListener, CompletableFuture<Unit> initialStage) {
        super(prepareExecutor, applyExecutor, manager, reloaders, (ResourceReloader.Synchronizer synchronizer, ResourceManager resourceManager, ResourceReloader reloader, Executor prepare, Executor apply) -> {
            AtomicLong prepareTimeNs = new AtomicLong();
            AtomicLong applyTimeNs = new AtomicLong();
            String managerName = resourceManager.getResourceType().map(ResourceType::getDirectory).map(StringUtils::capitalize).orElseGet((Supplier<String>)Function0.\u03bb((Function0)(Function0)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, getClass(), ()Ljava/lang/Class;)((ResourceManager)resourceManager)).andThen(Class::getSimpleName));
            ProfilerSystem prepareProfiler = new ProfilerSystem(Util.nanoTimeSupplier, () -> 0, false);
            ProfilerSystem applyProfiler = new ProfilerSystem(Util.nanoTimeSupplier, () -> 0, false);
            return reloader.reload(synchronizer, resourceManager, Profiler.union((Profiler)prepareProfiler, arg_0 -> ((FluentFunctions.FluentFunction)FluentFunctions.expression((Consumer)profilerListener.apply((Object)reloader, (Object)LOCATION_FORMAT.formatted(managerName, "%s", "preparation"))).compose((Function)Function1.lazy(() -> ((ProfilerSystem)prepareProfiler).getFullPath()))).apply(arg_0)), Profiler.union((Profiler)applyProfiler, arg_0 -> ((FluentFunctions.FluentFunction)FluentFunctions.expression((Consumer)profilerListener.apply((Object)reloader, (Object)LOCATION_FORMAT.formatted(managerName, "%s", "application"))).compose((Function)Function1.lazy(() -> ((ProfilerSystem)applyProfiler).getFullPath()))).apply(arg_0)), preparation -> prepare.execute(() -> {
                long prepareStart = Util.getMeasuringTimeNano();
                preparation.run();
                prepareTimeNs.addAndGet(Util.getMeasuringTimeNano() - prepareStart);
            }), application -> apply.execute(() -> {
                long applyStart = Util.getMeasuringTimeNano();
                application.run();
                applyTimeNs.addAndGet(Util.getMeasuringTimeNano() - applyStart);
            })).thenApplyAsync(dummy -> {
                StationAPI.LOGGER.debug("Finished reloading " + reloader.getName());
                return new Summary(reloader.getName(), prepareProfiler.getResult(), applyProfiler.getResult(), prepareTimeNs, applyTimeNs);
            }, applyExecutor);
        }, initialStage);
        this.reloadTimer.start();
        this.applyStageFuture = this.applyStageFuture.thenApplyAsync(this::finish, applyExecutor);
    }

    private List<Summary> finish(List<Summary> summaries) {
        this.reloadTimer.stop();
        long totalBlockingTime = 0L;
        StationAPI.LOGGER.info("Resource reload finished after {} ms", (Object)this.reloadTimer.elapsed(TimeUnit.MILLISECONDS));
        for (Summary summary : summaries) {
            long prepareTimeMs = TimeUnit.NANOSECONDS.toMillis(summary.prepareTimeNs.get());
            long applyTimeMs = TimeUnit.NANOSECONDS.toMillis(summary.applyTimeNs.get());
            StationAPI.LOGGER.info("{} took approximately {} ms ({} ms preparing, {} ms applying)", (Object)summary.name, (Object)(prepareTimeMs + applyTimeMs), (Object)prepareTimeMs, (Object)applyTimeMs);
            totalBlockingTime += applyTimeMs;
        }
        StationAPI.LOGGER.info("Total blocking time: {} ms", (Object)totalBlockingTime);
        return summaries;
    }

    public static class Summary {
        final String name;
        final ProfileResult prepareProfile;
        final ProfileResult applyProfile;
        final AtomicLong prepareTimeNs;
        final AtomicLong applyTimeNs;

        Summary(String name, ProfileResult prepareProfile, ProfileResult applyProfile, AtomicLong prepareTimeNs, AtomicLong applyTimeNs) {
            this.name = name;
            this.prepareProfile = prepareProfile;
            this.applyProfile = applyProfile;
            this.prepareTimeNs = prepareTimeNs;
            this.applyTimeNs = applyTimeNs;
        }
    }

    private static interface ListenableProfiler
    extends Profiler {
        default public void startTick() {
            this.push("root");
        }

        default public void endTick() {
        }

        default public void push(Supplier<String> locationGetter) {
            this.push(locationGetter.get());
        }

        default public void pop() {
        }

        default public void swap(String location) {
            this.push(location);
        }

        default public void swap(Supplier<String> locationGetter) {
            this.push(locationGetter);
        }

        default public void visit(String marker) {
        }

        default public void visit(Supplier<String> markerGetter) {
        }
    }
}

