/*
 * Decompiled with CFR 0.152.
 */
package net.modificationstation.stationapi.api.resource;

import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Stream;
import net.modificationstation.stationapi.api.resource.Resource;
import net.modificationstation.stationapi.api.resource.ResourceFactory;
import net.modificationstation.stationapi.api.resource.ResourcePack;
import net.modificationstation.stationapi.api.resource.ResourceType;
import net.modificationstation.stationapi.api.util.Identifier;
import net.modificationstation.stationapi.api.util.Namespace;

public interface ResourceManager
extends ResourceFactory {
    public Set<Namespace> getAllNamespaces();

    public List<Resource> getAllResources(Identifier var1);

    public Map<Identifier, Resource> findResources(String var1, Predicate<Identifier> var2);

    public Map<Identifier, List<Resource>> findAllResources(String var1, Predicate<Identifier> var2);

    public Stream<ResourcePack> streamResourcePacks();

    public Optional<ResourceType> getResourceType();

    public static enum Empty implements ResourceManager
    {
        INSTANCE;


        @Override
        public Set<Namespace> getAllNamespaces() {
            return Set.of();
        }

        @Override
        public Optional<Resource> getResource(Identifier identifier) {
            return Optional.empty();
        }

        @Override
        public List<Resource> getAllResources(Identifier id) {
            return List.of();
        }

        @Override
        public Map<Identifier, Resource> findResources(String startingPath, Predicate<Identifier> allowedPathPredicate) {
            return Map.of();
        }

        @Override
        public Map<Identifier, List<Resource>> findAllResources(String startingPath, Predicate<Identifier> allowedPathPredicate) {
            return Map.of();
        }

        @Override
        public Stream<ResourcePack> streamResourcePacks() {
            return Stream.empty();
        }

        @Override
        public Optional<ResourceType> getResourceType() {
            return Optional.empty();
        }
    }
}

