/*
 * Decompiled with CFR 0.152.
 */
package net.modificationstation.stationapi.impl.resource;

import com.google.common.base.Supplier;
import cyclops.control.Option;
import cyclops.function.Consumer3;
import java.util.Queue;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentLinkedQueue;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.mine_diver.unsafeevents.listener.EventListener;
import net.mine_diver.unsafeevents.listener.ListenerPriority;
import net.modificationstation.stationapi.api.StationAPI;
import net.modificationstation.stationapi.api.client.resource.ReloadScreenManager;
import net.modificationstation.stationapi.api.event.resource.DataReloadEvent;
import net.modificationstation.stationapi.api.mod.entrypoint.Entrypoint;
import net.modificationstation.stationapi.api.mod.entrypoint.EventBusPolicy;
import net.modificationstation.stationapi.api.resource.CompositeResourceReload;
import net.modificationstation.stationapi.api.resource.DataManager;
import net.modificationstation.stationapi.api.resource.ResourceReload;
import net.modificationstation.stationapi.api.resource.ResourceReloader;
import net.modificationstation.stationapi.api.resource.ResourceType;
import net.modificationstation.stationapi.api.util.Unit;
import net.modificationstation.stationapi.api.util.Util;
import net.modificationstation.stationapi.impl.resource.DefaultResourcePack;
import net.modificationstation.stationapi.impl.resource.ResourcePackManager;
import net.modificationstation.stationapi.impl.resource.ResourcePackProfile;
import net.modificationstation.stationapi.impl.resource.ResourcePackSource;
import net.modificationstation.stationapi.impl.resource.loader.ModResourcePackCreator;

@Entrypoint(eventBus=@EventBusPolicy(registerInstance=false))
@EventListener(phase="stationapi:internal")
public class DataReloaderImpl {
    private static final ResourcePackManager DATA_PACK_MANAGER = new ResourcePackManager(consumer -> consumer.accept(ResourcePackProfile.create("vanilla", "fixText", true, name -> new DefaultResourcePack(), ResourceType.SERVER_DATA, ResourcePackProfile.InsertionPosition.BOTTOM, ResourcePackSource.BUILTIN)), new ModResourcePackCreator(ResourceType.SERVER_DATA));
    private static final Queue<Runnable> TASKS = new ConcurrentLinkedQueue<Runnable>();
    private static final CompletableFuture<Unit> COMPLETED_UNIT_FUTURE = CompletableFuture.completedFuture(Unit.INSTANCE);

    @EventListener
    private static void scanPacks(DataReloadEvent event) {
        DATA_PACK_MANAGER.scanPacks();
    }

    @EventListener(priority=ListenerPriority.LOW)
    @Environment(value=EnvType.SERVER)
    private static void reloadResourceManager(DataReloadEvent event) {
        ResourceReload resourceReload = DataManager.INSTANCE.reload(Util.getMainWorkerExecutor(), TASKS::add, COMPLETED_UNIT_FUTURE, (Consumer3<ResourceReloader, String, String>)((Consumer3)(reloader, formatString, location) -> {}), DATA_PACK_MANAGER.createResourcePacks());
        while (!resourceReload.isComplete()) {
            Runnable task = TASKS.poll();
            if (task == null) continue;
            task.run();
        }
        resourceReload.throwException();
    }

    @EventListener(priority=ListenerPriority.LOW)
    @Environment(value=EnvType.CLIENT)
    private static void reloadResourceManagerClient(DataReloadEvent event) {
        ReloadScreenManager.getCurrentReload().flatMap(reload1 -> {
            Option option;
            if (reload1 instanceof CompositeResourceReload) {
                CompositeResourceReload composite = (CompositeResourceReload)reload1;
                option = Option.some((Object)composite);
            } else {
                option = Option.none();
            }
            return option;
        }).peek(manager -> manager.scheduleReload(StationAPI.NAMESPACE.id("data"), (Supplier<ResourceReload>)((Supplier)() -> DataManager.INSTANCE.reload(Util.getMainWorkerExecutor(), ReloadScreenManager.getApplicationExecutor(), COMPLETED_UNIT_FUTURE, (Consumer3<ResourceReloader, String, String>)((Consumer3)ReloadScreenManager::pushLocation), DATA_PACK_MANAGER.createResourcePacks()))));
    }
}

