/*
 * Decompiled with CFR 0.152.
 */
package net.modificationstation.stationapi.impl.resource;

import it.unimi.dsi.fastutil.objects.ReferenceArrayList;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.modificationstation.stationapi.api.StationAPI;
import net.modificationstation.stationapi.api.resource.InputSupplier;
import net.modificationstation.stationapi.api.resource.ResourcePack;
import net.modificationstation.stationapi.api.resource.ResourceType;
import net.modificationstation.stationapi.api.resource.metadata.ResourceMetadataReader;
import net.modificationstation.stationapi.api.util.Identifier;
import net.modificationstation.stationapi.api.util.Namespace;
import net.modificationstation.stationapi.api.util.PathUtil;
import net.modificationstation.stationapi.api.util.Util;
import net.modificationstation.stationapi.impl.resource.AbstractFileResourcePack;
import net.modificationstation.stationapi.impl.resource.DirectoryResourcePack;
import net.modificationstation.stationapi.impl.resource.metadata.PackResourceMetadata;
import net.modificationstation.stationapi.impl.resource.metadata.ResourceMetadataMap;
import org.jetbrains.annotations.Nullable;

public class DefaultResourcePack
implements ResourcePack {
    private static final List<Path> ROOT_PATHS = Namespace.MINECRAFT.getContainer().getRootPaths();
    private static final Map<ResourceType, List<Path>> NAMESPACE_PATHS = (Map)Util.make(new EnumMap(ResourceType.class), m -> {
        for (ResourceType type : ResourceType.values()) {
            for (Path rootPath : ROOT_PATHS) {
                Path typePath = rootPath.resolve(type.getDirectory());
                if (!Files.exists(typePath, new LinkOption[0])) continue;
                m.computeIfAbsent(type, key -> new ReferenceArrayList()).add(typePath);
            }
        }
    });
    private static final PackResourceMetadata METADATA = new PackResourceMetadata("fixText", 13);
    private static final ResourceMetadataMap METADATA_MAP = ResourceMetadataMap.of(PackResourceMetadata.SERIALIZER, METADATA);

    @Override
    @Nullable
    public InputSupplier<InputStream> openRoot(String ... segments) {
        PathUtil.validatePath((String[])segments);
        List<String> list = List.of(segments);
        for (Path path : ROOT_PATHS) {
            Path path2 = PathUtil.getPath((Path)path, list);
            if (!Files.exists(path2, new LinkOption[0]) || !DirectoryResourcePack.isValidPath(path2)) continue;
            return InputSupplier.create(path2);
        }
        return null;
    }

    @Override
    @Nullable
    public InputSupplier<InputStream> open(ResourceType type, Identifier id) {
        return (InputSupplier)PathUtil.split((String)id.path).get().map(segments -> {
            String string = id.namespace.toString();
            if (NAMESPACE_PATHS.containsKey((Object)type)) {
                for (Path path : NAMESPACE_PATHS.get((Object)type)) {
                    Path path2 = PathUtil.getPath((Path)path.resolve(string), (List)segments);
                    if (!Files.exists(path2, new LinkOption[0]) || !DirectoryResourcePack.isValidPath(path2)) continue;
                    return InputSupplier.create(path2);
                }
            }
            return null;
        }, result -> {
            StationAPI.LOGGER.error("Invalid path {}: {}", (Object)id, (Object)result.message());
            return null;
        });
    }

    @Override
    public void findResources(ResourceType type, Namespace namespace, String prefix, ResourcePack.ResultConsumer consumer) {
        boolean atRoot = prefix.startsWith("/");
        PathUtil.split((String)(atRoot ? prefix.substring(1) : prefix)).get().ifLeft(segments -> {
            List<Path> paths;
            if (namespace == Namespace.MINECRAFT && atRoot) {
                paths = ROOT_PATHS;
            } else if (NAMESPACE_PATHS.containsKey((Object)type)) {
                paths = NAMESPACE_PATHS.get((Object)type);
            } else {
                return;
            }
            int i = paths.size();
            if (i == 1) {
                DefaultResourcePack.collectIdentifiers(consumer, namespace, paths.get(0), segments, atRoot);
            } else if (i > 1) {
                HashMap<Identifier, InputSupplier<InputStream>> map = new HashMap<Identifier, InputSupplier<InputStream>>();
                for (int j = 0; j < i - 1; ++j) {
                    DefaultResourcePack.collectIdentifiers(map::putIfAbsent, namespace, paths.get(j), segments, atRoot);
                }
                Path path = paths.get(i - 1);
                if (map.isEmpty()) {
                    DefaultResourcePack.collectIdentifiers(consumer, namespace, path, segments, atRoot);
                } else {
                    DefaultResourcePack.collectIdentifiers(map::putIfAbsent, namespace, path, segments, atRoot);
                    map.forEach(consumer);
                }
            }
        }).ifRight(result -> StationAPI.LOGGER.error("Invalid path {}: {}", (Object)prefix, (Object)result.message()));
    }

    private static void collectIdentifiers(ResourcePack.ResultConsumer consumer, Namespace namespace, Path root, List<String> prefixSegments, boolean atRoot) {
        DirectoryResourcePack.findResources(namespace, atRoot ? root : root.resolve(namespace.toString()), prefixSegments, consumer, atRoot);
    }

    @Override
    public Set<Namespace> getNamespaces(ResourceType type) {
        return Set.of(Namespace.MINECRAFT);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    @Nullable
    public <T> T parseMetadata(ResourceMetadataReader<T> metaReader) {
        InputSupplier<InputStream> inputSupplier = this.openRoot("pack.mcmeta");
        if (inputSupplier == null) {
            return METADATA_MAP.get(metaReader);
        }
        try (InputStream inputStream = inputSupplier.get();){
            T object = AbstractFileResourcePack.parseMetadata(metaReader, inputStream);
            if (object == null) {
                T t = METADATA_MAP.get(metaReader);
                return t;
            }
            T t = object;
            return t;
        }
        catch (IOException iOException) {
            return METADATA_MAP.get(metaReader);
        }
    }

    @Override
    public String getName() {
        return "vanilla";
    }

    @Override
    public boolean isAlwaysStable() {
        return true;
    }

    @Override
    public void close() {
    }
}

