/*
 * Decompiled with CFR 0.152.
 */
package net.modificationstation.stationapi.impl.resource;

import com.google.common.base.Joiner;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.DirectoryStream;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.stream.Stream;
import net.modificationstation.stationapi.api.StationAPI;
import net.modificationstation.stationapi.api.resource.InputSupplier;
import net.modificationstation.stationapi.api.resource.ResourcePack;
import net.modificationstation.stationapi.api.resource.ResourceType;
import net.modificationstation.stationapi.api.util.Identifier;
import net.modificationstation.stationapi.api.util.Namespace;
import net.modificationstation.stationapi.api.util.PathUtil;
import net.modificationstation.stationapi.impl.resource.AbstractFileResourcePack;
import org.jetbrains.annotations.Nullable;

public class DirectoryResourcePack
extends AbstractFileResourcePack {
    private static final Joiner SEPARATOR_JOINER = Joiner.on((String)"/");
    private final Path root;

    public DirectoryResourcePack(String name, Path root, boolean alwaysStable) {
        super(name, alwaysStable);
        this.root = root;
    }

    @Override
    @Nullable
    public InputSupplier<InputStream> openRoot(String ... segments) {
        PathUtil.validatePath((String[])segments);
        Path path = PathUtil.getPath((Path)this.root, List.of(segments));
        if (Files.exists(path, new LinkOption[0])) {
            return InputSupplier.create(path);
        }
        return null;
    }

    public static boolean isValidPath(Path path) {
        return true;
    }

    @Override
    @Nullable
    public InputSupplier<InputStream> open(ResourceType type, Identifier id) {
        Path path = this.root.resolve(type.getDirectory()).resolve(id.namespace.toString());
        return DirectoryResourcePack.open(id, path);
    }

    public static InputSupplier<InputStream> open(Identifier id, Path path) {
        return (InputSupplier)PathUtil.split((String)id.path).get().map(segments -> {
            Path path2 = PathUtil.getPath((Path)path, (List)segments);
            return DirectoryResourcePack.open(path2);
        }, result -> {
            StationAPI.LOGGER.error("Invalid path {}: {}", (Object)id, (Object)result.message());
            return null;
        });
    }

    @Nullable
    private static InputSupplier<InputStream> open(Path path) {
        if (Files.exists(path, new LinkOption[0]) && DirectoryResourcePack.isValidPath(path)) {
            return InputSupplier.create(path);
        }
        return null;
    }

    @Override
    public void findResources(ResourceType type, Namespace namespace, String prefix, ResourcePack.ResultConsumer consumer) {
        PathUtil.split((String)prefix).get().ifLeft(prefixSegments -> {
            Path path = this.root.resolve(type.getDirectory()).resolve(namespace.toString());
            DirectoryResourcePack.findResources(namespace, path, prefixSegments, consumer);
        }).ifRight(result -> StationAPI.LOGGER.error("Invalid path {}: {}", (Object)prefix, (Object)result.message()));
    }

    public static void findResources(Namespace namespace, Path path, List<String> prefixSegments, ResourcePack.ResultConsumer consumer) {
        DirectoryResourcePack.findResources(namespace, path, prefixSegments, consumer, false);
    }

    public static void findResources(Namespace namespace, Path path, List<String> prefixSegments, ResourcePack.ResultConsumer consumer, boolean atRoot) {
        Path path22 = PathUtil.getPath((Path)path, prefixSegments);
        try (Stream<Path> stream22 = Files.find(path22, Integer.MAX_VALUE, (path2, attributes) -> attributes.isRegularFile(), new FileVisitOption[0]);){
            stream22.forEach(foundPath -> {
                Object string2 = SEPARATOR_JOINER.join((Iterable)path.relativize((Path)foundPath));
                if (atRoot) {
                    string2 = "/" + (String)string2;
                }
                Identifier identifier = Identifier.of((Namespace)namespace, (String)string2);
                consumer.accept(identifier, InputSupplier.create(foundPath));
            });
        }
        catch (NoSuchFileException stream22) {
        }
        catch (IOException iOException) {
            StationAPI.LOGGER.error("Failed to list path {}", (Object)path22, (Object)iOException);
        }
    }

    @Override
    public Set<Namespace> getNamespaces(ResourceType type) {
        HashSet set = Sets.newHashSet();
        Path path = this.root.resolve(type.getDirectory());
        try (DirectoryStream<Path> directoryStream22 = Files.newDirectoryStream(path);){
            for (Path path2 : directoryStream22) {
                String string = path2.getFileName().toString();
                if (string.equals(string.toLowerCase(Locale.ROOT))) {
                    set.add(Namespace.of((String)string));
                    continue;
                }
                StationAPI.LOGGER.warn("Ignored non-lowercase namespace: {} in {}", (Object)string, (Object)this.root);
            }
        }
        catch (NoSuchFileException directoryStream22) {
        }
        catch (IOException iOException) {
            StationAPI.LOGGER.error("Failed to list path {}", (Object)path, (Object)iOException);
        }
        return set;
    }

    @Override
    public void close() {
    }
}

