/*
 * Decompiled with CFR 0.152.
 */
package net.modificationstation.stationapi.impl.resource;

import it.unimi.dsi.fastutil.objects.ReferenceOpenHashSet;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.DirectoryStream;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Pattern;
import net.fabricmc.loader.api.ModContainer;
import net.fabricmc.loader.api.metadata.ModMetadata;
import net.modificationstation.stationapi.api.StationAPI;
import net.modificationstation.stationapi.api.resource.InputSupplier;
import net.modificationstation.stationapi.api.resource.ResourcePack;
import net.modificationstation.stationapi.api.resource.ResourcePackActivationType;
import net.modificationstation.stationapi.api.resource.ResourceType;
import net.modificationstation.stationapi.api.resource.metadata.ResourceMetadataReader;
import net.modificationstation.stationapi.api.util.Identifier;
import net.modificationstation.stationapi.api.util.Namespace;
import net.modificationstation.stationapi.api.util.PathUtil;
import net.modificationstation.stationapi.impl.resource.AbstractFileResourcePack;
import net.modificationstation.stationapi.impl.resource.ModResourcePack;
import net.modificationstation.stationapi.impl.resource.ModResourcePackUtil;
import org.jetbrains.annotations.Nullable;

public class ModNioResourcePack
implements ModResourcePack {
    private static final Pattern RESOURCE_PACK_PATH = Pattern.compile("[a-z0-9-_.]+");
    private static final FileSystem DEFAULT_FS = FileSystems.getDefault();
    private final Identifier id;
    private final String name;
    private final ModMetadata modInfo;
    private final List<Path> basePaths;
    private final ResourceType type;
    private final AutoCloseable closer;
    private final ResourcePackActivationType activationType;
    private final Map<ResourceType, Set<Namespace>> namespaces;
    private static final String resPrefix = ResourceType.CLIENT_RESOURCES.getDirectory() + "/";
    private static final String dataPrefix = ResourceType.SERVER_DATA.getDirectory() + "/";

    public static ModNioResourcePack create(Identifier id, String name, ModContainer mod, String subPath, ResourceType type, ResourcePackActivationType activationType) {
        ArrayList<Path> paths;
        ArrayList<Path> rootPaths = mod.getRootPaths();
        if (subPath == null) {
            paths = rootPaths;
        } else {
            paths = new ArrayList<Path>(rootPaths.size());
            for (Path path : rootPaths) {
                Path childPath = (path = path.toAbsolutePath().normalize()).resolve(subPath.replace("/", path.getFileSystem().getSeparator())).normalize();
                if (!childPath.startsWith(path) || !ModNioResourcePack.exists(childPath)) continue;
                paths.add(childPath);
            }
        }
        if (paths.isEmpty()) {
            return null;
        }
        ModNioResourcePack ret = new ModNioResourcePack(id, name, mod.getMetadata(), paths, type, null, activationType);
        return ret.getNamespaces(type).isEmpty() ? null : ret;
    }

    private ModNioResourcePack(Identifier id, String name, ModMetadata modInfo, List<Path> paths, ResourceType type, AutoCloseable closer, ResourcePackActivationType activationType) {
        this.id = id;
        this.name = name;
        this.modInfo = modInfo;
        this.basePaths = paths;
        this.type = type;
        this.closer = closer;
        this.activationType = activationType;
        this.namespaces = ModNioResourcePack.readNamespaces(paths, modInfo.getId());
    }

    static Map<ResourceType, Set<Namespace>> readNamespaces(List<Path> paths, String namespace) {
        EnumMap<ResourceType, Set<Namespace>> ret = new EnumMap<ResourceType, Set<Namespace>>(ResourceType.class);
        for (ResourceType type : ResourceType.values()) {
            ReferenceOpenHashSet namespaces = new ReferenceOpenHashSet();
            namespaces.add((Object)Namespace.MINECRAFT);
            for (Path path : paths) {
                Path dir = path.resolve(type.getDirectory());
                if (!Files.isDirectory(dir, new LinkOption[0])) continue;
                String separator = path.getFileSystem().getSeparator();
                try {
                    DirectoryStream<Path> ds = Files.newDirectoryStream(dir);
                    try {
                        for (Path p : ds) {
                            if (!Files.isDirectory(p, new LinkOption[0])) continue;
                            String s = p.getFileName().toString();
                            if (!RESOURCE_PACK_PATH.matcher(s = s.replace(separator, "")).matches()) {
                                StationAPI.LOGGER.warn("Fabric NioResourcePack: ignored invalid namespace: {} in mod ID {}", (Object)s, (Object)namespace);
                                continue;
                            }
                            namespaces.add((Object)Namespace.of((String)s));
                        }
                    }
                    finally {
                        if (ds == null) continue;
                        ds.close();
                    }
                }
                catch (IOException e) {
                    StationAPI.LOGGER.warn("getNamespaces in mod " + namespace + " failed!", (Throwable)e);
                }
            }
            ret.put(type, (Set<Namespace>)namespaces);
        }
        return ret;
    }

    private Path getPath(String filename) {
        if (this.hasAbsentNs(filename)) {
            return null;
        }
        for (Path basePath : this.basePaths) {
            Path childPath = basePath.resolve(filename.replace("/", basePath.getFileSystem().getSeparator())).toAbsolutePath().normalize();
            if (!childPath.startsWith(basePath) || !ModNioResourcePack.exists(childPath)) continue;
            return childPath;
        }
        return null;
    }

    private boolean hasAbsentNs(String filename) {
        ResourceType type;
        int prefixLen;
        if (filename.startsWith(resPrefix)) {
            prefixLen = resPrefix.length();
            type = ResourceType.CLIENT_RESOURCES;
        } else if (filename.startsWith(dataPrefix)) {
            prefixLen = dataPrefix.length();
            type = ResourceType.SERVER_DATA;
        } else {
            return false;
        }
        int nsEnd = filename.indexOf(47, prefixLen);
        if (nsEnd < 0) {
            return false;
        }
        return !this.namespaces.get((Object)type).contains(Namespace.of((String)filename.substring(prefixLen, nsEnd)));
    }

    private InputSupplier<InputStream> openFile(String filename) {
        Path path = this.getPath(filename);
        if (path != null && Files.isRegularFile(path, new LinkOption[0])) {
            return () -> Files.newInputStream(path, new OpenOption[0]);
        }
        if (ModResourcePackUtil.containsDefault(this.modInfo, filename)) {
            return () -> ModResourcePackUtil.openDefault(this.modInfo, this.type, filename);
        }
        return null;
    }

    @Override
    @Nullable
    public InputSupplier<InputStream> openRoot(String ... pathSegments) {
        PathUtil.validatePath((String[])pathSegments);
        return this.openFile(String.join((CharSequence)"/", pathSegments));
    }

    @Override
    @Nullable
    public InputSupplier<InputStream> open(ResourceType type, Identifier id) {
        Path path = this.getPath(ModNioResourcePack.getFilename(type, id));
        return path == null ? null : InputSupplier.create(path);
    }

    @Override
    public void findResources(ResourceType type, final Namespace namespace, String path, final ResourcePack.ResultConsumer visitor) {
        final boolean atRoot = path.startsWith("/");
        if (!atRoot && !this.namespaces.getOrDefault((Object)type, Collections.emptySet()).contains(namespace)) {
            return;
        }
        Iterator<Path> iterator = this.basePaths.iterator();
        while (iterator.hasNext()) {
            String separator;
            Path basePath;
            final Path nsPath = atRoot ? basePath : basePath.resolve(type.getDirectory()).resolve(namespace.toString());
            Path searchPath = nsPath.resolve((atRoot ? path.substring(1) : path).replace("/", separator = (basePath = iterator.next()).getFileSystem().getSeparator())).normalize();
            if (!ModNioResourcePack.exists(searchPath)) continue;
            try {
                Files.walkFileTree(searchPath, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                    @Override
                    public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) {
                        Object filename = nsPath.relativize(file).toString().replace(separator, "/");
                        if (atRoot) {
                            filename = "/" + (String)filename;
                        }
                        Identifier identifier = namespace.id((String)filename);
                        visitor.accept(identifier, InputSupplier.create(file));
                        return FileVisitResult.CONTINUE;
                    }
                });
            }
            catch (IOException e) {
                StationAPI.LOGGER.warn("findResources at " + path + " in namespace " + String.valueOf(namespace) + ", mod " + this.modInfo.getId() + " failed!", (Throwable)e);
            }
        }
    }

    @Override
    public Set<Namespace> getNamespaces(ResourceType type) {
        return this.namespaces.getOrDefault((Object)type, Collections.emptySet());
    }

    @Override
    public <T> T parseMetadata(ResourceMetadataReader<T> metaReader) throws IOException {
        try (InputStream is = Objects.requireNonNull(this.openFile("pack.mcmeta")).get();){
            T t = AbstractFileResourcePack.parseMetadata(metaReader, is);
            return t;
        }
    }

    @Override
    public void close() {
        if (this.closer != null) {
            try {
                this.closer.close();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    @Override
    public ModMetadata getFabricModMetadata() {
        return this.modInfo;
    }

    public ResourcePackActivationType getActivationType() {
        return this.activationType;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public Identifier getId() {
        return this.id;
    }

    private static boolean exists(Path path) {
        return path.getFileSystem() == DEFAULT_FS ? path.toFile().exists() : Files.exists(path, new LinkOption[0]);
    }

    private static String getFilename(ResourceType type, Identifier id) {
        return String.format(Locale.ROOT, "%s/%s/%s", type.getDirectory(), id.namespace, id.path);
    }
}

