/*
 * Decompiled with CFR 0.152.
 */
package net.modificationstation.stationapi.impl.resource;

import com.google.common.base.Charsets;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import it.unimi.dsi.fastutil.objects.Object2ReferenceMap;
import it.unimi.dsi.fastutil.objects.Object2ReferenceOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import it.unimi.dsi.fastutil.objects.ObjectSet;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.List;
import java.util.Objects;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.fabricmc.loader.api.metadata.CustomValue;
import net.fabricmc.loader.api.metadata.ModMetadata;
import net.modificationstation.stationapi.api.StationAPI;
import net.modificationstation.stationapi.api.resource.ResourcePackActivationType;
import net.modificationstation.stationapi.api.resource.ResourceType;
import net.modificationstation.stationapi.impl.resource.ModNioResourcePack;
import net.modificationstation.stationapi.impl.resource.ModResourcePack;
import org.apache.commons.io.IOUtils;
import org.jetbrains.annotations.Nullable;

public final class ModResourcePackUtil {
    private static final Gson GSON = new Gson();

    private ModResourcePackUtil() {
    }

    public static void appendModResourcePacks(List<ModResourcePack> packs, ResourceType type, @Nullable String subPath) {
        String priorityKey = String.format("station-resource-loader-v0:%s_priority", type.getDirectory());
        Object2ReferenceOpenHashMap lowerThan = new Object2ReferenceOpenHashMap();
        Object2ReferenceOpenHashMap higherThan = new Object2ReferenceOpenHashMap();
        for (ModContainer container : FabricLoader.getInstance().getAllMods()) {
            ModNioResourcePack pack;
            ModMetadata metadata = container.getMetadata();
            if (metadata.getType().equals("builtin")) continue;
            String id = metadata.getId();
            if (metadata.containsCustomValue(priorityKey)) {
                CustomValue.CvObject priority = metadata.getCustomValue(priorityKey).getAsObject();
                ModResourcePackUtil.updatePriorities((Object2ReferenceMap<String, ObjectSet<String>>)lowerThan, id, priority, "lowerThan");
                ModResourcePackUtil.updatePriorities((Object2ReferenceMap<String, ObjectSet<String>>)higherThan, id, priority, "higherThan");
            }
            if ((pack = ModNioResourcePack.create(StationAPI.NAMESPACE.id(id), ModResourcePackUtil.getName(metadata), container, subPath, type, ResourcePackActivationType.ALWAYS_ENABLED)) == null) continue;
            packs.add(pack);
        }
        packs.sort((arg_0, arg_1) -> ModResourcePackUtil.lambda$appendModResourcePacks$0((Object2ReferenceMap)lowerThan, (Object2ReferenceMap)higherThan, arg_0, arg_1));
    }

    private static void updatePriorities(Object2ReferenceMap<String, ObjectSet<String>> setToUpdate, String id, CustomValue.CvObject priority, String keyToUpdate) {
        if (priority.containsKey(keyToUpdate)) {
            CustomValue v = priority.get(keyToUpdate);
            (switch (v.getType()) {
                case CustomValue.CvType.ARRAY -> StreamSupport.stream(priority.get(keyToUpdate).getAsArray().spliterator(), false).map(CustomValue::getAsString);
                case CustomValue.CvType.STRING -> Stream.of(v.getAsString());
                default -> throw new IllegalStateException("Unexpected value: " + String.valueOf(v.getType()));
            }).forEach(arg_0 -> ((ObjectSet)setToUpdate.computeIfAbsent((Object)id, id1 -> new ObjectOpenHashSet())).add(arg_0));
        }
    }

    public static boolean containsDefault(ModMetadata info, String filename) {
        return "pack.mcmeta".equals(filename);
    }

    public static InputStream openDefault(ModMetadata info, ResourceType type, String filename) {
        return switch (filename) {
            case "pack.mcmeta" -> {
                String description = Objects.requireNonNullElse(info.getName(), "");
                String metadata = ModResourcePackUtil.serializeMetadata(type == ResourceType.CLIENT_RESOURCES ? 13 : 12, description);
                yield IOUtils.toInputStream((String)metadata, (Charset)Charsets.UTF_8);
            }
            default -> null;
        };
    }

    public static String serializeMetadata(int packVersion, String description) {
        JsonObject pack = new JsonObject();
        pack.addProperty("pack_format", (Number)packVersion);
        pack.addProperty("description", description);
        JsonObject metadata = new JsonObject();
        metadata.add("pack", (JsonElement)pack);
        return GSON.toJson((JsonElement)metadata);
    }

    public static String getName(ModMetadata info) {
        if (info.getName() != null) {
            return info.getName();
        }
        return info.getId();
    }

    private static /* synthetic */ int lambda$appendModResourcePacks$0(Object2ReferenceMap lowerThan, Object2ReferenceMap higherThan, ModResourcePack pack1, ModResourcePack pack2) {
        ObjectSet s;
        String id1 = pack1.getFabricModMetadata().getId();
        String id2 = pack2.getFabricModMetadata().getId();
        return lowerThan.containsKey((Object)id1) && ((s = (ObjectSet)lowerThan.get((Object)id1)).contains((Object)"*") || s.contains((Object)id2)) || higherThan.containsKey((Object)id2) && ((s = (ObjectSet)higherThan.get((Object)id2)).contains((Object)"*") || s.contains((Object)id1)) ? -1 : (higherThan.containsKey((Object)id1) && ((s = (ObjectSet)higherThan.get((Object)id1)).contains((Object)"*") || s.contains((Object)id2)) || lowerThan.containsKey((Object)id2) && ((s = (ObjectSet)lowerThan.get((Object)id2)).contains((Object)"*") || s.contains((Object)id1)) ? 1 : 0);
    }
}

