/*
 * Decompiled with CFR 0.152.
 */
package net.modificationstation.stationapi.impl.resource;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import it.unimi.dsi.fastutil.objects.Object2ObjectArrayMap;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Stream;
import net.modificationstation.stationapi.api.StationAPI;
import net.modificationstation.stationapi.api.resource.InputSupplier;
import net.modificationstation.stationapi.api.resource.Resource;
import net.modificationstation.stationapi.api.resource.ResourceManager;
import net.modificationstation.stationapi.api.resource.ResourcePack;
import net.modificationstation.stationapi.api.resource.ResourceType;
import net.modificationstation.stationapi.api.resource.metadata.ResourceMetadata;
import net.modificationstation.stationapi.api.util.Identifier;
import net.modificationstation.stationapi.api.util.Namespace;
import net.modificationstation.stationapi.api.util.PathUtil;
import net.modificationstation.stationapi.impl.resource.GroupResourcePack;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.Nullable;

public class NamespaceResourceManager
implements ResourceManager {
    protected final List<FilterablePack> packList = Lists.newArrayList();
    public final ResourceType type;
    private final Namespace namespace;

    public NamespaceResourceManager(ResourceType type, Namespace namespace) {
        this.type = type;
        this.namespace = namespace;
    }

    public void addPack(ResourcePack pack) {
        this.addPack(pack.getName(), pack, null);
    }

    public void addPack(ResourcePack pack, Predicate<Identifier> filter) {
        this.addPack(pack.getName(), pack, filter);
    }

    public void addPack(String name, Predicate<Identifier> filter) {
        this.addPack(name, null, filter);
    }

    private void addPack(String name, @Nullable ResourcePack underlyingPack, @Nullable Predicate<Identifier> filter) {
        this.packList.add(new FilterablePack(name, underlyingPack, filter));
    }

    @Override
    public Set<Namespace> getAllNamespaces() {
        return ImmutableSet.of((Object)this.namespace);
    }

    private Function<ResourcePack, InputSupplier<InputStream>> createOpener(Identifier id) {
        if (id.namespace == Namespace.MINECRAFT && id.path.startsWith("/")) {
            String[] segments = (String[])((List)PathUtil.split((String)id.path.substring(1)).getOrThrow(false, arg_0 -> ((Logger)StationAPI.LOGGER).error(arg_0))).toArray(String[]::new);
            return pack -> pack.openRoot((String[])segments.clone());
        }
        return pack -> pack.open(this.type, id);
    }

    @Override
    public Optional<Resource> getResource(Identifier id) {
        Function<ResourcePack, InputSupplier<InputStream>> opener = this.createOpener(id);
        for (int i = this.packList.size() - 1; i >= 0; --i) {
            InputSupplier<InputStream> inputSupplier;
            FilterablePack filterablePack = this.packList.get(i);
            ResourcePack resourcePack = filterablePack.underlying;
            if (resourcePack != null && (inputSupplier = opener.apply(resourcePack)) != null) {
                InputSupplier<ResourceMetadata> inputSupplier2 = this.createMetadataSupplier(id, i);
                return Optional.of(NamespaceResourceManager.createResource(resourcePack, id, inputSupplier, inputSupplier2));
            }
            if (!filterablePack.isFiltered(id)) continue;
            StationAPI.LOGGER.warn("Resource {} not found, but was filtered by pack {}", (Object)id, (Object)filterablePack.name);
            return Optional.empty();
        }
        return Optional.empty();
    }

    private static Resource createResource(ResourcePack pack, Identifier id, InputSupplier<InputStream> supplier, InputSupplier<ResourceMetadata> metadataSupplier) {
        return new Resource(pack, NamespaceResourceManager.wrapForDebug(id, pack, supplier), metadataSupplier);
    }

    private static InputSupplier<InputStream> wrapForDebug(Identifier id, ResourcePack pack, InputSupplier<InputStream> supplier) {
        return StationAPI.LOGGER.isDebugEnabled() ? () -> new DebugInputStream((InputStream)supplier.get(), id, pack.getName()) : supplier;
    }

    @Override
    public List<Resource> getAllResources(Identifier id) {
        Identifier identifier = NamespaceResourceManager.getMetadataPath(id);
        Function<ResourcePack, InputSupplier<InputStream>> opener = this.createOpener(id);
        Function<ResourcePack, InputSupplier<InputStream>> metaOpener = this.createOpener(identifier);
        ArrayList<Resource> list = new ArrayList<Resource>();
        boolean bl = false;
        String string = null;
        for (int i = this.packList.size() - 1; i >= 0; --i) {
            FilterablePack filterablePack = this.packList.get(i);
            ResourcePack resourcePack = filterablePack.underlying;
            if (resourcePack != null) {
                if (resourcePack instanceof GroupResourcePack) {
                    GroupResourcePack group = (GroupResourcePack)resourcePack;
                    group.appendResources(this.type, id, list);
                    continue;
                }
                InputSupplier<InputStream> inputSupplier = opener.apply(resourcePack);
                if (inputSupplier != null) {
                    InputSupplier<ResourceMetadata> inputSupplier2 = bl ? ResourceMetadata.NONE_SUPPLIER : () -> {
                        InputSupplier inputSupplier1 = (InputSupplier)metaOpener.apply(resourcePack);
                        return inputSupplier1 != null ? NamespaceResourceManager.loadMetadata(inputSupplier1) : ResourceMetadata.NONE;
                    };
                    list.add(new Resource(resourcePack, inputSupplier, inputSupplier2));
                }
            }
            if (filterablePack.isFiltered(id)) {
                string = filterablePack.name;
                break;
            }
            if (!filterablePack.isFiltered(identifier)) continue;
            bl = true;
        }
        if (list.isEmpty() && string != null) {
            StationAPI.LOGGER.warn("Resource {} not found, but was filtered by pack {}", (Object)id, string);
        }
        return Lists.reverse(list);
    }

    private static boolean isMcmeta(Identifier id) {
        return id.path.endsWith(".mcmeta");
    }

    private static Identifier getMetadataFileName(Identifier id) {
        return id.namespace.id(id.path.substring(0, id.path.length() - ".mcmeta".length()));
    }

    public static Identifier getMetadataPath(Identifier id) {
        return id.withSuffixedPath(".mcmeta");
    }

    @Override
    public Map<Identifier, Resource> findResources(String startingPath, Predicate<Identifier> allowedPathPredicate) {
        record Result(ResourcePack pack, InputSupplier<InputStream> supplier, int packIndex) {
        }
        HashMap<Identifier, Result> map = new HashMap<Identifier, Result>();
        HashMap map2 = new HashMap();
        int i = this.packList.size();
        for (int j = 0; j < i; ++j) {
            FilterablePack filterablePack = this.packList.get(j);
            filterablePack.removeFiltered(map.keySet());
            filterablePack.removeFiltered(map2.keySet());
            ResourcePack resourcePack = filterablePack.underlying;
            if (resourcePack == null) continue;
            int finalJ = j;
            resourcePack.findResources(this.type, this.namespace, startingPath, (id, supplier) -> {
                if (NamespaceResourceManager.isMcmeta(id)) {
                    if (allowedPathPredicate.test(NamespaceResourceManager.getMetadataFileName(id))) {
                        map2.put(id, new Result(resourcePack, (InputSupplier<InputStream>)supplier, finalJ));
                    }
                } else if (allowedPathPredicate.test((Identifier)id)) {
                    map.put((Identifier)id, new Result(resourcePack, (InputSupplier<InputStream>)supplier, finalJ));
                }
            });
        }
        TreeMap map3 = Maps.newTreeMap();
        map.forEach((id, result) -> {
            Identifier identifier = NamespaceResourceManager.getMetadataPath(id);
            Result result2 = (Result)map2.get(identifier);
            InputSupplier<ResourceMetadata> inputSupplier = result2 != null && result2.packIndex >= result.packIndex ? NamespaceResourceManager.getMetadataSupplier(result2.supplier) : ResourceMetadata.NONE_SUPPLIER;
            map3.put(id, NamespaceResourceManager.createResource(result.pack, id, result.supplier, inputSupplier));
        });
        return map3;
    }

    private InputSupplier<ResourceMetadata> createMetadataSupplier(Identifier id, int index) {
        return () -> {
            Identifier identifier2 = NamespaceResourceManager.getMetadataPath(id);
            Function<ResourcePack, InputSupplier<InputStream>> opener = this.createOpener(identifier2);
            for (int j = this.packList.size() - 1; j >= index; --j) {
                InputSupplier<InputStream> inputSupplier;
                FilterablePack filterablePack = this.packList.get(j);
                ResourcePack resourcePack = filterablePack.underlying;
                if (resourcePack != null && (inputSupplier = opener.apply(resourcePack)) != null) {
                    return NamespaceResourceManager.loadMetadata(inputSupplier);
                }
                if (filterablePack.isFiltered(identifier2)) break;
            }
            return ResourceMetadata.NONE;
        };
    }

    private static InputSupplier<ResourceMetadata> getMetadataSupplier(InputSupplier<InputStream> supplier) {
        return () -> NamespaceResourceManager.loadMetadata(supplier);
    }

    public static ResourceMetadata loadMetadata(InputSupplier<InputStream> supplier) throws IOException {
        ResourceMetadata var2;
        try (InputStream inputStream = supplier.get();){
            var2 = ResourceMetadata.create(inputStream);
        }
        return var2;
    }

    private static void applyFilter(FilterablePack pack, Map<Identifier, EntryList> idToEntryList) {
        for (EntryList entryList : idToEntryList.values()) {
            if (pack.isFiltered(entryList.id)) {
                entryList.fileSources.clear();
                continue;
            }
            if (!pack.isFiltered(entryList.metadataId())) continue;
            entryList.metaSources.clear();
        }
    }

    private void findAndAdd(FilterablePack pack, String startingPath, Predicate<Identifier> allowedPathPredicate, Map<Identifier, EntryList> idToEntryList) {
        ResourcePack resourcePack = pack.underlying;
        if (resourcePack != null) {
            resourcePack.findResources(this.type, this.namespace, startingPath, (id, supplier) -> {
                if (NamespaceResourceManager.isMcmeta(id)) {
                    Identifier identifier = NamespaceResourceManager.getMetadataFileName(id);
                    if (!allowedPathPredicate.test(identifier)) {
                        return;
                    }
                    idToEntryList.computeIfAbsent(identifier, (Function<Identifier, EntryList>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, <init>(net.modificationstation.stationapi.api.util.Identifier ), (Lnet/modificationstation/stationapi/api/util/Identifier;)Lnet/modificationstation/stationapi/impl/resource/NamespaceResourceManager$EntryList;)()).metaSources.put(resourcePack, (InputSupplier<InputStream>)supplier);
                } else {
                    if (!allowedPathPredicate.test((Identifier)id)) {
                        return;
                    }
                    idToEntryList.computeIfAbsent(id, (Function<Identifier, EntryList>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, <init>(net.modificationstation.stationapi.api.util.Identifier ), (Lnet/modificationstation/stationapi/api/util/Identifier;)Lnet/modificationstation/stationapi/impl/resource/NamespaceResourceManager$EntryList;)()).fileSources.add(new FileSource(resourcePack, (InputSupplier<InputStream>)supplier));
                }
            });
        }
    }

    @Override
    public Map<Identifier, List<Resource>> findAllResources(String startingPath, Predicate<Identifier> allowedPathPredicate) {
        HashMap map = Maps.newHashMap();
        for (FilterablePack filterablePack : this.packList) {
            NamespaceResourceManager.applyFilter(filterablePack, map);
            this.findAndAdd(filterablePack, startingPath, allowedPathPredicate, map);
        }
        TreeMap treeMap = Maps.newTreeMap();
        for (EntryList entryList : map.values()) {
            if (entryList.fileSources.isEmpty()) continue;
            ArrayList<Resource> list = new ArrayList<Resource>();
            for (FileSource fileSource : entryList.fileSources) {
                ResourcePack resourcePack = fileSource.sourcePack;
                InputSupplier<InputStream> inputSupplier = entryList.metaSources.get(resourcePack);
                InputSupplier<ResourceMetadata> inputSupplier2 = inputSupplier != null ? NamespaceResourceManager.getMetadataSupplier(inputSupplier) : ResourceMetadata.NONE_SUPPLIER;
                list.add(NamespaceResourceManager.createResource(resourcePack, entryList.id, fileSource.supplier, inputSupplier2));
            }
            treeMap.put(entryList.id, list);
        }
        return treeMap;
    }

    @Override
    public Stream<ResourcePack> streamResourcePacks() {
        return this.packList.stream().map(pack -> pack.underlying).filter(Objects::nonNull);
    }

    @Override
    public Optional<ResourceType> getResourceType() {
        return Optional.of(this.type);
    }

    record FilterablePack(String name, @Nullable ResourcePack underlying, @Nullable Predicate<Identifier> filter) {
        public void removeFiltered(Collection<Identifier> ids) {
            if (this.filter != null) {
                ids.removeIf(this.filter);
            }
        }

        public boolean isFiltered(Identifier id) {
            return this.filter != null && this.filter.test(id);
        }
    }

    record EntryList(Identifier id, Identifier metadataId, List<FileSource> fileSources, Map<ResourcePack, InputSupplier<InputStream>> metaSources) {
        EntryList(Identifier id) {
            this(id, NamespaceResourceManager.getMetadataPath(id), new ArrayList<FileSource>(), (Map<ResourcePack, InputSupplier<InputStream>>)new Object2ObjectArrayMap());
        }
    }

    record FileSource(ResourcePack sourcePack, InputSupplier<InputStream> supplier) {
    }

    private static class DebugInputStream
    extends FilterInputStream {
        private final Supplier<String> leakMessage;
        private boolean closed;

        public DebugInputStream(InputStream parent, Identifier id, String packName) {
            super(parent);
            Exception exception = new Exception("Stacktrace");
            this.leakMessage = () -> {
                StringWriter stringWriter = new StringWriter();
                exception.printStackTrace(new PrintWriter(stringWriter));
                return "Leaked resource: '" + String.valueOf(id) + "' loaded from pack: '" + packName + "'\n" + String.valueOf(stringWriter);
            };
        }

        @Override
        public void close() throws IOException {
            super.close();
            this.closed = true;
        }

        protected void finalize() throws Throwable {
            if (!this.closed) {
                StationAPI.LOGGER.warn("{}", (Object)this.leakMessage.get());
            }
            super.finalize();
        }
    }
}

