/*
 * Decompiled with CFR 0.152.
 */
package net.modificationstation.stationapi.impl.resource;

import com.google.common.collect.Lists;
import cyclops.function.Consumer3;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.modificationstation.stationapi.api.StationAPI;
import net.modificationstation.stationapi.api.resource.Resource;
import net.modificationstation.stationapi.api.resource.ResourceManager;
import net.modificationstation.stationapi.api.resource.ResourcePack;
import net.modificationstation.stationapi.api.resource.ResourceReload;
import net.modificationstation.stationapi.api.resource.ResourceReloader;
import net.modificationstation.stationapi.api.resource.ResourceType;
import net.modificationstation.stationapi.api.resource.SimpleResourceReload;
import net.modificationstation.stationapi.api.util.Identifier;
import net.modificationstation.stationapi.api.util.Namespace;
import net.modificationstation.stationapi.api.util.Unit;
import net.modificationstation.stationapi.impl.resource.LifecycledResourceManager;
import net.modificationstation.stationapi.impl.resource.LifecycledResourceManagerImpl;
import org.apache.logging.log4j.util.Supplier;

public class ReloadableResourceManager
implements ResourceManager,
AutoCloseable {
    private LifecycledResourceManager activeManager;
    private final List<ResourceReloader> reloaders = Lists.newArrayList();
    private final ResourceType type;

    public ReloadableResourceManager(ResourceType type) {
        this.type = type;
        this.activeManager = new LifecycledResourceManagerImpl(type, List.of());
    }

    @Override
    public void close() {
        this.activeManager.close();
    }

    public void registerReloader(ResourceReloader reloader) {
        this.reloaders.add(reloader);
    }

    public ResourceReload reload(Executor prepareExecutor, Executor applyExecutor, CompletableFuture<Unit> initialStage, List<ResourcePack> packs) {
        StationAPI.LOGGER.info("Reloading ResourceManager: {}", new Supplier[]{() -> packs.stream().map(ResourcePack::getName).collect(Collectors.joining(", "))});
        this.activeManager.close();
        this.activeManager = new LifecycledResourceManagerImpl(this.type, packs);
        return SimpleResourceReload.start(this.activeManager, this.reloaders, prepareExecutor, applyExecutor, initialStage);
    }

    public ResourceReload reload(Executor prepareExecutor, Executor applyExecutor, CompletableFuture<Unit> initialStage, Consumer3<ResourceReloader, String, String> profilerListener, List<ResourcePack> packs) {
        StationAPI.LOGGER.info("Reloading ResourceManager: {}", new Supplier[]{() -> packs.stream().map(ResourcePack::getName).collect(Collectors.joining(", "))});
        this.activeManager.close();
        this.activeManager = new LifecycledResourceManagerImpl(this.type, packs);
        return SimpleResourceReload.start(this.activeManager, this.reloaders, prepareExecutor, applyExecutor, profilerListener, initialStage);
    }

    @Override
    public Optional<Resource> getResource(Identifier identifier) {
        return this.activeManager.getResource(identifier);
    }

    @Override
    public Set<Namespace> getAllNamespaces() {
        return this.activeManager.getAllNamespaces();
    }

    @Override
    public List<Resource> getAllResources(Identifier id) {
        return this.activeManager.getAllResources(id);
    }

    @Override
    public Map<Identifier, Resource> findResources(String startingPath, Predicate<Identifier> allowedPathPredicate) {
        return this.activeManager.findResources(startingPath, allowedPathPredicate);
    }

    @Override
    public Map<Identifier, List<Resource>> findAllResources(String startingPath, Predicate<Identifier> allowedPathPredicate) {
        return this.activeManager.findAllResources(startingPath, allowedPathPredicate);
    }

    @Override
    public Stream<ResourcePack> streamResourcePacks() {
        return this.activeManager.streamResourcePacks();
    }

    @Override
    public Optional<ResourceType> getResourceType() {
        return Optional.of(this.type);
    }
}

