/*
 * Decompiled with CFR 0.152.
 */
package net.modificationstation.stationapi.impl.resource;

import net.modificationstation.stationapi.api.resource.ResourceType;

public enum ResourcePackCompatibility {
    TOO_OLD("old"),
    TOO_NEW("new"),
    COMPATIBLE("compatible");

    private final String notification;
    private final String confirmMessage;

    private ResourcePackCompatibility(String translationSuffix) {
        this.notification = "pack.incompatible." + translationSuffix;
        this.confirmMessage = "pack.incompatible.confirm." + translationSuffix;
    }

    public boolean isCompatible() {
        return this == COMPATIBLE;
    }

    public static ResourcePackCompatibility from(int packVersion, ResourceType type) {
        int i;
        switch (type) {
            default: {
                throw new IncompatibleClassChangeError();
            }
            case CLIENT_RESOURCES: {
                int n = 13;
                break;
            }
            case SERVER_DATA: {
                int n = i = 12;
            }
        }
        if (packVersion < i) {
            return TOO_OLD;
        }
        if (packVersion > i) {
            return TOO_NEW;
        }
        return COMPATIBLE;
    }

    public String getNotification() {
        return this.notification;
    }

    public String getConfirmMessage() {
        return this.confirmMessage;
    }
}

