/*
 * Decompiled with CFR 0.152.
 */
package net.modificationstation.stationapi.impl.resource;

import java.util.function.UnaryOperator;

public interface ResourcePackSource {
    public static final UnaryOperator<String> NONE_SOURCE_TEXT_SUPPLIER = UnaryOperator.identity();
    public static final ResourcePackSource NONE = ResourcePackSource.create(NONE_SOURCE_TEXT_SUPPLIER, true);
    public static final ResourcePackSource BUILTIN = ResourcePackSource.create(ResourcePackSource.getSourceTextSupplier("pack.source.builtin"), true);
    public static final ResourcePackSource FEATURE = ResourcePackSource.create(ResourcePackSource.getSourceTextSupplier("pack.source.feature"), false);
    public static final ResourcePackSource WORLD = ResourcePackSource.create(ResourcePackSource.getSourceTextSupplier("pack.source.world"), true);
    public static final ResourcePackSource SERVER = ResourcePackSource.create(ResourcePackSource.getSourceTextSupplier("pack.source.server"), true);

    public String decorate(String var1);

    public boolean canBeEnabledLater();

    public static ResourcePackSource create(final UnaryOperator<String> sourceTextSupplier, final boolean canBeEnabledLater) {
        return new ResourcePackSource(){

            @Override
            public String decorate(String packName) {
                return (String)sourceTextSupplier.apply(packName);
            }

            @Override
            public boolean canBeEnabledLater() {
                return canBeEnabledLater;
            }
        };
    }

    private static UnaryOperator<String> getSourceTextSupplier(String translationKey) {
        return text -> "fixText";
    }
}

