/*
 * Decompiled with CFR 0.152.
 */
package net.modificationstation.stationapi.impl.resource.loader;

import com.google.common.base.Charsets;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.List;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.modificationstation.stationapi.api.resource.InputSupplier;
import net.modificationstation.stationapi.api.resource.ResourceType;
import net.modificationstation.stationapi.api.resource.metadata.ResourceMetadataReader;
import net.modificationstation.stationapi.impl.resource.AbstractFileResourcePack;
import net.modificationstation.stationapi.impl.resource.GroupResourcePack;
import net.modificationstation.stationapi.impl.resource.ModResourcePack;
import org.apache.commons.io.IOUtils;
import org.jetbrains.annotations.Nullable;

public class FabricModResourcePack
extends GroupResourcePack {
    public FabricModResourcePack(ResourceType type, List<ModResourcePack> packs) {
        super(type, packs);
    }

    @Override
    public InputSupplier<InputStream> openRoot(String ... pathSegments) {
        String fileName;
        return switch (fileName = String.join((CharSequence)"/", pathSegments)) {
            case "pack.mcmeta" -> {
                String description = "pack.description.modResources";
                String fallback = "Mod resources.";
                int v0 = switch (this.type) {
                    default -> throw new IncompatibleClassChangeError();
                    case ResourceType.CLIENT_RESOURCES -> 13;
                    case ResourceType.SERVER_DATA -> 12;
                };
                String pack = String.format("{\"pack\":{\"pack_format\":" + v0 + ",\"description\":{\"translate\":\"%s\",\"fallback\":\"%s.\"}}}", description, fallback);
                yield () -> IOUtils.toInputStream((String)pack, (Charset)Charsets.UTF_8);
            }
            case "pack.png" -> FabricLoader.getInstance().getModContainer("station-resource-loader-v0").flatMap(container -> container.getMetadata().getIconPath(512).flatMap(arg_0 -> ((ModContainer)container).findPath(arg_0))).map(path -> () -> Files.newInputStream(path, new OpenOption[0])).orElse(null);
            default -> super.openRoot(pathSegments);
        };
    }

    @Override
    @Nullable
    public <T> T parseMetadata(ResourceMetadataReader<T> metaReader) throws IOException {
        InputSupplier<InputStream> inputSupplier = this.openRoot("pack.mcmeta");
        if (inputSupplier == null) {
            return null;
        }
        try (InputStream input = inputSupplier.get();){
            T t = AbstractFileResourcePack.parseMetadata(metaReader, input);
            return t;
        }
    }

    @Override
    public String getName() {
        return "Fabric Mods";
    }

    @Override
    public boolean isAlwaysStable() {
        return true;
    }
}

