/*
 * Decompiled with CFR 0.152.
 */
package net.modificationstation.stationapi.impl.resource.loader;

import java.util.ArrayList;
import java.util.function.Consumer;
import net.modificationstation.stationapi.api.resource.ResourceType;
import net.modificationstation.stationapi.impl.resource.ModResourcePack;
import net.modificationstation.stationapi.impl.resource.ModResourcePackUtil;
import net.modificationstation.stationapi.impl.resource.ResourcePackProfile;
import net.modificationstation.stationapi.impl.resource.ResourcePackProvider;
import net.modificationstation.stationapi.impl.resource.ResourcePackSource;
import net.modificationstation.stationapi.impl.resource.loader.FabricModResourcePack;
import net.modificationstation.stationapi.impl.resource.loader.ResourceManagerHelperImpl;

public class ModResourcePackCreator
implements ResourcePackProvider {
    public static final ResourcePackSource RESOURCE_PACK_SOURCE = new ResourcePackSource(){

        @Override
        public String decorate(String packName) {
            return "fixText";
        }

        @Override
        public boolean canBeEnabledLater() {
            return true;
        }
    };
    public static final ModResourcePackCreator CLIENT_RESOURCE_PACK_PROVIDER = new ModResourcePackCreator(ResourceType.CLIENT_RESOURCES);
    private final ResourceType type;

    public ModResourcePackCreator(ResourceType type) {
        this.type = type;
    }

    @Override
    public void register(Consumer<ResourcePackProfile> consumer) {
        String title;
        ResourcePackProfile resourcePackProfile;
        ArrayList<ModResourcePack> packs = new ArrayList<ModResourcePack>();
        ModResourcePackUtil.appendModResourcePacks(packs, this.type, null);
        if (!packs.isEmpty() && (resourcePackProfile = ResourcePackProfile.create("fabric", title = "pack.name.fabricMods", true, factory -> new FabricModResourcePack(this.type, packs), this.type, ResourcePackProfile.InsertionPosition.TOP, RESOURCE_PACK_SOURCE)) != null) {
            consumer.accept(resourcePackProfile);
        }
        ResourceManagerHelperImpl.registerBuiltinResourcePacks(this.type, consumer);
    }
}

