/*
 * Decompiled with CFR 0.152.
 */
package net.modificationstation.stationapi.impl.resource.loader;

import com.google.common.collect.Lists;
import com.mojang.datafixers.util.Pair;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import net.fabricmc.loader.api.ModContainer;
import net.modificationstation.stationapi.api.resource.IdentifiableResourceReloadListener;
import net.modificationstation.stationapi.api.resource.ResourceManagerHelper;
import net.modificationstation.stationapi.api.resource.ResourcePack;
import net.modificationstation.stationapi.api.resource.ResourcePackActivationType;
import net.modificationstation.stationapi.api.resource.ResourceReloader;
import net.modificationstation.stationapi.api.resource.ResourceType;
import net.modificationstation.stationapi.api.util.Identifier;
import net.modificationstation.stationapi.impl.resource.ModNioResourcePack;
import net.modificationstation.stationapi.impl.resource.ResourcePackProfile;
import net.modificationstation.stationapi.impl.resource.loader.BuiltinModResourcePackSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResourceManagerHelperImpl
implements ResourceManagerHelper {
    private static final Map<ResourceType, ResourceManagerHelperImpl> registryMap = new HashMap<ResourceType, ResourceManagerHelperImpl>();
    private static final Set<Pair<String, ModNioResourcePack>> builtinResourcePacks = new HashSet<Pair<String, ModNioResourcePack>>();
    private static final Logger LOGGER = LoggerFactory.getLogger(ResourceManagerHelperImpl.class);
    private final Set<Identifier> addedListenerIds = new HashSet<Identifier>();
    private final Set<IdentifiableResourceReloadListener> addedListeners = new LinkedHashSet<IdentifiableResourceReloadListener>();

    public static ResourceManagerHelperImpl get(ResourceType type) {
        return registryMap.computeIfAbsent(type, t -> new ResourceManagerHelperImpl());
    }

    public static boolean registerBuiltinResourcePack(Identifier id, String subPath, ModContainer container, String displayName, ResourcePackActivationType activationType) {
        List paths = container.getRootPaths();
        String separator = ((Path)paths.get(0)).getFileSystem().getSeparator();
        subPath = subPath.replace("/", separator);
        ModNioResourcePack resourcePack = ModNioResourcePack.create(id, displayName, container, subPath, ResourceType.CLIENT_RESOURCES, activationType);
        ModNioResourcePack dataPack = ModNioResourcePack.create(id, displayName, container, subPath, ResourceType.SERVER_DATA, activationType);
        if (resourcePack == null && dataPack == null) {
            return false;
        }
        if (resourcePack != null) {
            builtinResourcePacks.add((Pair<String, ModNioResourcePack>)new Pair((Object)displayName, (Object)resourcePack));
        }
        if (dataPack != null) {
            builtinResourcePacks.add((Pair<String, ModNioResourcePack>)new Pair((Object)displayName, (Object)dataPack));
        }
        return true;
    }

    public static boolean registerBuiltinResourcePack(Identifier id, String subPath, ModContainer container, ResourcePackActivationType activationType) {
        return ResourceManagerHelperImpl.registerBuiltinResourcePack(id, subPath, container, String.valueOf(id.namespace) + "/" + id.path, activationType);
    }

    public static void registerBuiltinResourcePacks(ResourceType resourceType, Consumer<ResourcePackProfile> consumer) {
        for (Pair<String, ModNioResourcePack> entry : builtinResourcePacks) {
            ModNioResourcePack pack = (ModNioResourcePack)entry.getSecond();
            if (pack.getNamespaces(resourceType).isEmpty()) continue;
            ResourcePackProfile profile = ResourcePackProfile.create(((ModNioResourcePack)entry.getSecond()).getId().toString(), (String)entry.getFirst(), pack.getActivationType() == ResourcePackActivationType.ALWAYS_ENABLED, ignored -> (ResourcePack)entry.getSecond(), resourceType, ResourcePackProfile.InsertionPosition.TOP, new BuiltinModResourcePackSource(pack.getFabricModMetadata().getName()));
            consumer.accept(profile);
        }
    }

    public static List<ResourceReloader> sort(ResourceType type, List<ResourceReloader> listeners) {
        ResourceManagerHelperImpl instance = ResourceManagerHelperImpl.get(type);
        if (instance != null) {
            ArrayList<ResourceReloader> mutable = new ArrayList<ResourceReloader>(listeners);
            instance.sort(mutable);
            return Collections.unmodifiableList(mutable);
        }
        return listeners;
    }

    protected void sort(List<ResourceReloader> listeners) {
        listeners.removeAll(this.addedListeners);
        ArrayList listenersToAdd = Lists.newArrayList(this.addedListeners);
        HashSet<Identifier> resolvedIds = new HashSet<Identifier>();
        for (ResourceReloader listener : listeners) {
            if (!(listener instanceof IdentifiableResourceReloadListener)) continue;
            resolvedIds.add(((IdentifiableResourceReloadListener)listener).getId());
        }
        int lastSize = -1;
        while (listeners.size() != lastSize) {
            lastSize = listeners.size();
            Iterator it = listenersToAdd.iterator();
            while (it.hasNext()) {
                IdentifiableResourceReloadListener listener = (IdentifiableResourceReloadListener)it.next();
                if (!resolvedIds.containsAll(listener.getDependencies())) continue;
                resolvedIds.add(listener.getId());
                listeners.add(listener);
                it.remove();
            }
        }
        for (IdentifiableResourceReloadListener listener : listenersToAdd) {
            LOGGER.warn("Could not resolve dependencies for listener: " + String.valueOf(listener.getId()) + "!");
        }
    }

    @Override
    public void registerReloadListener(IdentifiableResourceReloadListener listener) {
        if (!this.addedListenerIds.add(listener.getId())) {
            LOGGER.warn("Tried to register resource reload listener " + String.valueOf(listener.getId()) + " twice!");
            return;
        }
        if (!this.addedListeners.add(listener)) {
            throw new RuntimeException("Listener with previously unknown ID " + String.valueOf(listener.getId()) + " already in listener set!");
        }
    }
}

