/*
 * Decompiled with CFR 0.152.
 */
package net.modificationstation.stationapi.impl.server.network;

import java.util.HashMap;
import java.util.stream.Collectors;
import net.fabricmc.loader.api.ModContainer;
import net.fabricmc.loader.api.metadata.ModMetadata;
import net.mine_diver.unsafeevents.listener.EventListener;
import net.minecraft.class_629;
import net.minecraft.class_69;
import net.modificationstation.stationapi.api.StationAPI;
import net.modificationstation.stationapi.api.event.registry.MessageListenerRegistryEvent;
import net.modificationstation.stationapi.api.mod.entrypoint.Entrypoint;
import net.modificationstation.stationapi.api.mod.entrypoint.EventBusPolicy;
import net.modificationstation.stationapi.api.registry.Registry;
import net.modificationstation.stationapi.api.server.event.network.PlayerAttemptLoginEvent;
import net.modificationstation.stationapi.api.util.Identifier;
import net.modificationstation.stationapi.impl.network.ModdedPacketHandlerSetter;
import net.modificationstation.stationapi.impl.network.VanillaChecker;

@Entrypoint(eventBus=@EventBusPolicy(registerInstance=false))
@EventListener(phase="stationapi:internal")
public class ServerVanillaChecker {
    @EventListener
    private static void onPlayerLogin(PlayerAttemptLoginEvent event) {
        if ((event.loginHelloPacket.field_1211 & VanillaChecker.MASK) == VanillaChecker.MASK) {
            ((ModdedPacketHandlerSetter)event.serverLoginNetworkHandler).setModded();
        } else if (!VanillaChecker.CLIENT_REQUIRED_MODS.isEmpty()) {
            StationAPI.LOGGER.error("Player \"" + event.loginHelloPacket.field_1210 + "\" attempted joining the server without " + StationAPI.NAMESPACE.getName() + ", disconnecting.");
            event.serverLoginNetworkHandler.method_417(class_629.method_2049((String)"disconnect.stationapi:missing_station"));
        }
    }

    @EventListener
    private static void registerMessages(MessageListenerRegistryEvent event) {
        Registry.register((Registry)event.registry, (Identifier)StationAPI.NAMESPACE.id("modlist"), (player, message) -> {
            if (!VanillaChecker.CLIENT_REQUIRED_MODS.isEmpty()) {
                StationAPI.LOGGER.info("Received a list of mods from player \"" + player.field_528 + "\", verifying...");
                class_69 serverPlayer = (class_69)player;
                String version = message.strings[0];
                String serverStationVersion = StationAPI.NAMESPACE.getVersion().getFriendlyString();
                if (!version.equals(serverStationVersion)) {
                    StationAPI.LOGGER.error("Player \"" + player.field_528 + "\" has a mismatching " + StationAPI.NAMESPACE.getName() + " version \"" + version + "\", disconnecting.");
                    serverPlayer.field_255.method_833(class_629.method_2050((String)"disconnect.stationapi:station_version_mismatch", (Object[])new Object[]{serverStationVersion, version}));
                    return;
                }
                HashMap<String, String> clientMods = new HashMap<String, String>();
                for (int i = 1; i < message.strings.length; i += 2) {
                    clientMods.put(message.strings[i], message.strings[i + 1]);
                }
                StationAPI.LOGGER.info("Player \"" + player.field_528 + "\"'s mods: " + clientMods.entrySet().stream().map(stringStringEntry -> "modid=" + (String)stringStringEntry.getKey() + " version=" + (String)stringStringEntry.getValue()).collect(Collectors.joining(", ", "[", "]")));
                for (ModContainer serverMod : VanillaChecker.CLIENT_REQUIRED_MODS) {
                    ModMetadata modMetadata = serverMod.getMetadata();
                    String modid = modMetadata.getId();
                    String serverVersion = modMetadata.getVersion().getFriendlyString();
                    if (clientMods.containsKey(modid)) {
                        String clientVersion = (String)clientMods.get(modid);
                        if (clientVersion != null && clientVersion.equals(serverVersion)) continue;
                        StationAPI.LOGGER.error("Player \"" + player.field_528 + "\" has a mismatching " + modMetadata.getName() + " (" + modid + ") version \"" + clientVersion + "\", disconnecting.");
                        serverPlayer.field_255.method_833(class_629.method_2050((String)"disconnect.stationapi:mod_version_mismatch", (Object[])new Object[]{modMetadata.getName(), modid, serverVersion, clientVersion == null ? "null" : clientVersion}));
                        return;
                    }
                    StationAPI.LOGGER.error("Player \"" + player.field_528 + "\" has a missing mod " + modMetadata.getName() + " (" + modid + "), disconnecting.");
                    serverPlayer.field_255.method_833(class_629.method_2050((String)"disconnect.stationapi:missing_mod", (Object[])new Object[]{modMetadata.getName(), modid, serverVersion}));
                    return;
                }
                StationAPI.LOGGER.info("Player \"" + player.field_528 + "\"'s mods have passed verification.");
            }
        });
    }
}

