/*
 * Decompiled with CFR 0.152.
 */
package net.modificationstation.stationapi.api.vanillafix.datadamager.damage;

import com.mojang.datafixers.DataFix;
import com.mojang.datafixers.DataFixUtils;
import com.mojang.datafixers.TypeRewriteRule;
import com.mojang.datafixers.schemas.Schema;
import com.mojang.datafixers.types.Type;
import com.mojang.serialization.Dynamic;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import net.minecraft.class_257;
import net.minecraft.class_56;
import net.modificationstation.stationapi.api.datafixer.TypeReferences;
import net.modificationstation.stationapi.api.util.collection.PackedIntegerArray;
import net.modificationstation.stationapi.api.util.math.MathHelper;
import net.modificationstation.stationapi.api.vanillafix.datafixer.schema.StationFlatteningItemStackSchema;
import net.modificationstation.stationapi.impl.world.FlattenedWorldManager;
import net.modificationstation.stationapi.impl.world.chunk.NibbleArray;

public class StationFlatteningToMcRegionChunkDamage
extends DataFix {
    private static final int CHUNK_SIZE = 32768;
    private static final byte[] DEFAULT_BLOCK_LIGHT = new byte[16384];
    private static final byte[] DEFAULT_SKY_LIGHT = new byte[16384];
    private final String name;

    public StationFlatteningToMcRegionChunkDamage(Schema outputSchema, String name) {
        super(outputSchema, true);
        this.name = name;
    }

    private Dynamic<?> damageChunk(Dynamic<?> dynamic) {
        Optional optional = dynamic.get("Level").result();
        if (optional.isPresent() && ((Dynamic)optional.get()).get(FlattenedWorldManager.SECTIONS).asListOpt(Function.identity()).result().isPresent()) {
            return dynamic.set("Level", new Level((Dynamic)optional.get()).transform());
        }
        return dynamic;
    }

    protected TypeRewriteRule makeRule() {
        Type type = this.getInputSchema().getType(TypeReferences.CHUNK);
        Type type2 = this.getOutputSchema().getType(TypeReferences.CHUNK);
        return this.writeFixAndRead(this.name, type, type2, this::damageChunk);
    }

    static {
        Arrays.fill(DEFAULT_BLOCK_LIGHT, (byte)(class_56.field_2758.field_2759 << 4 | class_56.field_2758.field_2759));
        Arrays.fill(DEFAULT_SKY_LIGHT, (byte)(class_56.field_2757.field_2759 << 4 | class_56.field_2757.field_2759));
    }

    static final class Level {
        private final Dynamic<?> level;
        private final List<Section> sections;
        private final ByteBuffer height_map;

        public Level(Dynamic<?> dynamic) {
            this.level = dynamic;
            this.sections = dynamic.get(FlattenedWorldManager.SECTIONS).asList(Section::new);
            this.height_map = dynamic.get("height_map").asByteBuffer();
        }

        public Dynamic<?> transform() {
            Dynamic<?> self = this.level;
            class_257 blockLight = new class_257(Arrays.copyOf(DEFAULT_BLOCK_LIGHT, 16384));
            byte[] blocks = new byte[32768];
            class_257 data = new class_257(32768);
            class_257 skyLight = new class_257(Arrays.copyOf(DEFAULT_SKY_LIGHT, 16384));
            for (Section section : this.sections) {
                int yOff = section.y << 4;
                for (int i = 0; i < 4096; ++i) {
                    int x = i >> 8;
                    int y = i >> 4 & 0xF;
                    int z = i & 0xF;
                    int worldY = yOff + y;
                    blockLight.method_1704(x, worldY, z, section.block_light.getValue(i));
                    blocks[x << 11 | z << 7 | worldY] = (byte)StationFlatteningItemStackSchema.lookupOldBlockId(section.palette.get(section.statesData.get((y << 4 | z) << 4 | x)));
                    data.method_1704(x, worldY, z, section.data.getValue(i));
                    skyLight.method_1704(x, worldY, z, section.sky_light.getValue(i));
                }
            }
            byte[] heightMap = new byte[256];
            for (int i = 0; i < heightMap.length; ++i) {
                heightMap[i] = this.height_map.get(i << 1);
            }
            return self.set("BlockLight", self.createByteList(ByteBuffer.wrap(blockLight.field_2103))).set("Blocks", self.createByteList(ByteBuffer.wrap(blocks))).set("Data", self.createByteList(ByteBuffer.wrap(data.field_2103))).set("HeightMap", self.createByteList(ByteBuffer.wrap(heightMap))).set("SkyLight", self.createByteList(ByteBuffer.wrap(skyLight.field_2103))).remove(FlattenedWorldManager.SECTIONS).remove("height_map");
        }
    }

    static final class Section {
        private final Dynamic<?> section;
        private final int y;
        private final NibbleArray block_light = new NibbleArray(4096);
        private final List<? extends Dynamic<?>> palette;
        private final PackedIntegerArray statesData;
        private final NibbleArray data = new NibbleArray(4096);
        private final NibbleArray sky_light = new NibbleArray(4096);

        public Section(Dynamic<?> section) {
            this.section = section;
            this.y = section.get("y").asInt(0);
            this.block_light.copyArray(DataFixUtils.toArray((ByteBuffer)section.get("block_light").asByteBuffer()));
            Map blockStates = section.get("block_states").asMap(dynamic -> dynamic.asString(""), Function.identity());
            this.palette = ((Dynamic)blockStates.get("palette")).asList(Function.identity());
            long[] states = blockStates.containsKey("data") ? ((Dynamic)blockStates.get("data")).asLongStream().toArray() : null;
            int elementBits = Math.max(4, MathHelper.ceilLog2((int)this.palette.size()));
            int elementsPerLong = 64 / elementBits;
            this.statesData = new PackedIntegerArray(elementBits, states == null ? 4096 : states.length * elementsPerLong, states);
            this.data.copyArray(DataFixUtils.toArray((ByteBuffer)section.get("data").asByteBuffer()));
            this.sky_light.copyArray(DataFixUtils.toArray((ByteBuffer)section.get("sky_light").asByteBuffer()));
        }
    }
}

