/*
 * Decompiled with CFR 0.152.
 */
package net.modificationstation.stationapi.api.vanillafix.datafixer.schema;

import com.mojang.datafixers.DSL;
import com.mojang.datafixers.schemas.Schema;
import com.mojang.datafixers.types.templates.TypeTemplate;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.class_8;
import net.modificationstation.stationapi.api.datafixer.TypeReferences;
import net.modificationstation.stationapi.api.nbt.NbtOps;
import net.modificationstation.stationapi.api.util.Util;
import net.modificationstation.stationapi.api.vanillafix.datafixer.schema.IdentifierNormalizingSchema;
import net.modificationstation.stationapi.impl.vanillafix.datafixer.VanillaDataFixerImpl;

public class StationFlatteningItemStackSchema
extends Schema {
    private static final Dynamic<?>[] OLD_ID_TO_BLOCKSTATE = new Dynamic[256];
    private static final Object2IntOpenHashMap<String> BLOCK_TO_OLD_ID = (Object2IntOpenHashMap)Util.make((Object)new Object2IntOpenHashMap(256), map -> map.defaultReturnValue(0));
    private static final String[] OLD_ID_TO_ITEM = new String[32000];
    private static final Object2IntOpenHashMap<String> ITEM_TO_OLD_ID = (Object2IntOpenHashMap)Util.make((Object)new Object2IntOpenHashMap(512), map -> map.defaultReturnValue(0));

    public static void putState(int oldId, String id, class_8 properties) {
        StationFlatteningItemStackSchema.putState(oldId, (class_8)Util.make((Object)new class_8(), tag -> {
            tag.method_1019("Name", id);
            tag.method_1018("Properties", properties);
        }));
    }

    public static void putState(int oldId, String id) {
        StationFlatteningItemStackSchema.putState(oldId, (class_8)Util.make((Object)new class_8(), tag -> tag.method_1019("Name", id)));
    }

    public static void putState(int oldId, class_8 tag) {
        Dynamic dynamic;
        String id = tag.method_1031("Name");
        BLOCK_TO_OLD_ID.put((Object)id, oldId);
        StationFlatteningItemStackSchema.OLD_ID_TO_BLOCKSTATE[oldId] = dynamic = new Dynamic((DynamicOps)NbtOps.INSTANCE, (Object)tag);
        StationFlatteningItemStackSchema.putItem(oldId, id);
    }

    public static Dynamic<?> lookupState(int stateId) {
        Dynamic<?> dynamic = null;
        if (stateId >= 0 && stateId < OLD_ID_TO_BLOCKSTATE.length) {
            dynamic = OLD_ID_TO_BLOCKSTATE[stateId];
        }
        return dynamic == null ? OLD_ID_TO_BLOCKSTATE[0] : dynamic;
    }

    public static String lookupBlockId(int id) {
        if (id < 0 || id >= OLD_ID_TO_BLOCKSTATE.length) {
            return "minecraft:air";
        }
        Dynamic<?> dynamic = OLD_ID_TO_BLOCKSTATE[id];
        return dynamic == null ? "minecraft:air" : dynamic.get("Name").asString("");
    }

    public static <T> int lookupOldBlockId(Dynamic<T> dynamic) {
        return BLOCK_TO_OLD_ID.getInt((Object)dynamic.get("Name").asString(""));
    }

    public static void putItem(int oldId, String id) {
        StationFlatteningItemStackSchema.OLD_ID_TO_ITEM[oldId] = id;
        ITEM_TO_OLD_ID.put((Object)id, oldId);
    }

    public static String lookupItem(int oldId) {
        if (oldId < 0 || oldId >= OLD_ID_TO_ITEM.length) {
            return "minecraft:air";
        }
        String item = OLD_ID_TO_ITEM[oldId];
        return item == null ? "minecraft:air" : item;
    }

    public static int lookupOldItemId(String id) {
        return ITEM_TO_OLD_ID.getInt((Object)id);
    }

    public StationFlatteningItemStackSchema(int versionKey, Schema parent) {
        super(versionKey, parent);
    }

    public void registerTypes(Schema schema, Map<String, Supplier<TypeTemplate>> entityTypes, Map<String, Supplier<TypeTemplate>> blockEntityTypes) {
        super.registerTypes(schema, entityTypes, blockEntityTypes);
        schema.registerType(true, TypeReferences.ITEM_STACK, () -> DSL.fields((String)VanillaDataFixerImpl.STATION_ID, (TypeTemplate)TypeReferences.ITEM_NAME.in(schema)));
        schema.registerType(false, TypeReferences.ITEM_NAME, () -> DSL.constType(IdentifierNormalizingSchema.getIdentifierType()));
    }

    static {
        StationFlatteningItemStackSchema.putState(0, "minecraft:air");
        StationFlatteningItemStackSchema.putState(1, "minecraft:stone");
        StationFlatteningItemStackSchema.putState(2, "minecraft:grass_block");
        StationFlatteningItemStackSchema.putState(3, "minecraft:dirt");
        StationFlatteningItemStackSchema.putState(4, "minecraft:cobblestone");
        StationFlatteningItemStackSchema.putState(5, "minecraft:oak_planks");
        StationFlatteningItemStackSchema.putState(6, "minecraft:sapling");
        StationFlatteningItemStackSchema.putState(7, "minecraft:bedrock");
        StationFlatteningItemStackSchema.putState(8, "minecraft:flowing_water");
        StationFlatteningItemStackSchema.putState(9, "minecraft:water");
        StationFlatteningItemStackSchema.putState(10, "minecraft:flowing_lava");
        StationFlatteningItemStackSchema.putState(11, "minecraft:lava");
        StationFlatteningItemStackSchema.putState(12, "minecraft:sand");
        StationFlatteningItemStackSchema.putState(13, "minecraft:gravel");
        StationFlatteningItemStackSchema.putState(14, "minecraft:gold_ore");
        StationFlatteningItemStackSchema.putState(15, "minecraft:iron_ore");
        StationFlatteningItemStackSchema.putState(16, "minecraft:coal_ore");
        StationFlatteningItemStackSchema.putState(17, "minecraft:log");
        StationFlatteningItemStackSchema.putState(18, "minecraft:leaves");
        StationFlatteningItemStackSchema.putState(19, "minecraft:sponge");
        StationFlatteningItemStackSchema.putState(20, "minecraft:glass");
        StationFlatteningItemStackSchema.putState(21, "minecraft:lapis_ore");
        StationFlatteningItemStackSchema.putState(22, "minecraft:lapis_block");
        StationFlatteningItemStackSchema.putState(23, "minecraft:dispenser");
        StationFlatteningItemStackSchema.putState(24, "minecraft:sandstone");
        StationFlatteningItemStackSchema.putState(25, "minecraft:note_block");
        StationFlatteningItemStackSchema.putState(26, "minecraft:red_bed");
        StationFlatteningItemStackSchema.putState(27, "minecraft:powered_rail");
        StationFlatteningItemStackSchema.putState(28, "minecraft:detector_rail");
        StationFlatteningItemStackSchema.putState(29, "minecraft:sticky_piston");
        StationFlatteningItemStackSchema.putState(30, "minecraft:cobweb");
        StationFlatteningItemStackSchema.putState(31, "minecraft:grass");
        StationFlatteningItemStackSchema.putState(32, "minecraft:dead_bush");
        StationFlatteningItemStackSchema.putState(33, "minecraft:piston");
        StationFlatteningItemStackSchema.putState(34, "minecraft:piston_head");
        StationFlatteningItemStackSchema.putState(35, "minecraft:wool");
        StationFlatteningItemStackSchema.putState(36, "minecraft:moving_piston");
        StationFlatteningItemStackSchema.putState(37, "minecraft:dandelion");
        StationFlatteningItemStackSchema.putState(38, "minecraft:rose");
        StationFlatteningItemStackSchema.putState(39, "minecraft:brown_mushroom");
        StationFlatteningItemStackSchema.putState(40, "minecraft:red_mushroom");
        StationFlatteningItemStackSchema.putState(41, "minecraft:gold_block");
        StationFlatteningItemStackSchema.putState(42, "minecraft:iron_block");
        StationFlatteningItemStackSchema.putState(43, "minecraft:double_slab");
        StationFlatteningItemStackSchema.putState(44, "minecraft:slab");
        StationFlatteningItemStackSchema.putState(45, "minecraft:bricks");
        StationFlatteningItemStackSchema.putState(46, "minecraft:tnt");
        StationFlatteningItemStackSchema.putState(47, "minecraft:bookshelf");
        StationFlatteningItemStackSchema.putState(48, "minecraft:mossy_cobblestone");
        StationFlatteningItemStackSchema.putState(49, "minecraft:obsidian");
        StationFlatteningItemStackSchema.putState(50, "minecraft:torch");
        StationFlatteningItemStackSchema.putState(51, "minecraft:fire");
        StationFlatteningItemStackSchema.putState(52, "minecraft:spawner");
        StationFlatteningItemStackSchema.putState(53, "minecraft:oak_stairs");
        StationFlatteningItemStackSchema.putState(54, "minecraft:chest");
        StationFlatteningItemStackSchema.putState(55, "minecraft:redstone_wire");
        StationFlatteningItemStackSchema.putState(56, "minecraft:diamond_ore");
        StationFlatteningItemStackSchema.putState(57, "minecraft:diamond_block");
        StationFlatteningItemStackSchema.putState(58, "minecraft:crafting_table");
        StationFlatteningItemStackSchema.putState(59, "minecraft:wheat");
        StationFlatteningItemStackSchema.putState(60, "minecraft:farmland");
        StationFlatteningItemStackSchema.putState(61, "minecraft:furnace");
        StationFlatteningItemStackSchema.putState(62, "minecraft:furnace_lit");
        StationFlatteningItemStackSchema.putState(63, "minecraft:oak_sign");
        StationFlatteningItemStackSchema.putState(64, "minecraft:oak_door");
        StationFlatteningItemStackSchema.putState(65, "minecraft:ladder");
        StationFlatteningItemStackSchema.putState(66, "minecraft:rail");
        StationFlatteningItemStackSchema.putState(67, "minecraft:cobblestone_stairs");
        StationFlatteningItemStackSchema.putState(68, "minecraft:oak_wall_sign");
        StationFlatteningItemStackSchema.putState(69, "minecraft:lever");
        StationFlatteningItemStackSchema.putState(70, "minecraft:oak_pressure_plate");
        StationFlatteningItemStackSchema.putState(71, "minecraft:iron_door");
        StationFlatteningItemStackSchema.putState(72, "minecraft:stone_pressure_plate");
        StationFlatteningItemStackSchema.putState(73, "minecraft:redstone_ore");
        StationFlatteningItemStackSchema.putState(74, "minecraft:redstone_ore_lit");
        StationFlatteningItemStackSchema.putState(75, "minecraft:redstone_torch");
        StationFlatteningItemStackSchema.putState(76, "minecraft:redstone_torch_lit");
        StationFlatteningItemStackSchema.putState(77, "minecraft:stone_button");
        StationFlatteningItemStackSchema.putState(78, "minecraft:snow");
        StationFlatteningItemStackSchema.putState(79, "minecraft:ice");
        StationFlatteningItemStackSchema.putState(80, "minecraft:snow_block");
        StationFlatteningItemStackSchema.putState(81, "minecraft:cactus");
        StationFlatteningItemStackSchema.putState(82, "minecraft:clay");
        StationFlatteningItemStackSchema.putState(83, "minecraft:sugar_cane");
        StationFlatteningItemStackSchema.putState(84, "minecraft:jukebox");
        StationFlatteningItemStackSchema.putState(85, "minecraft:oak_fence");
        StationFlatteningItemStackSchema.putState(86, "minecraft:carved_pumpkin");
        StationFlatteningItemStackSchema.putState(87, "minecraft:netherrack");
        StationFlatteningItemStackSchema.putState(88, "minecraft:soul_sand");
        StationFlatteningItemStackSchema.putState(89, "minecraft:glowstone");
        StationFlatteningItemStackSchema.putState(90, "minecraft:nether_portal");
        StationFlatteningItemStackSchema.putState(91, "minecraft:jack_o_lantern");
        StationFlatteningItemStackSchema.putState(92, "minecraft:cake");
        StationFlatteningItemStackSchema.putState(93, "minecraft:repeater");
        StationFlatteningItemStackSchema.putState(94, "minecraft:repeater_lit");
        StationFlatteningItemStackSchema.putState(95, "minecraft:locked_chest");
        StationFlatteningItemStackSchema.putState(96, "minecraft:oak_trapdoor");
        StationFlatteningItemStackSchema.putItem(256, "minecraft:iron_shovel");
        StationFlatteningItemStackSchema.putItem(257, "minecraft:iron_pickaxe");
        StationFlatteningItemStackSchema.putItem(258, "minecraft:iron_axe");
        StationFlatteningItemStackSchema.putItem(259, "minecraft:flint_and_steel");
        StationFlatteningItemStackSchema.putItem(260, "minecraft:apple");
        StationFlatteningItemStackSchema.putItem(261, "minecraft:bow");
        StationFlatteningItemStackSchema.putItem(262, "minecraft:arrow");
        StationFlatteningItemStackSchema.putItem(263, "minecraft:coal");
        StationFlatteningItemStackSchema.putItem(264, "minecraft:diamond");
        StationFlatteningItemStackSchema.putItem(265, "minecraft:iron_ingot");
        StationFlatteningItemStackSchema.putItem(266, "minecraft:gold_ingot");
        StationFlatteningItemStackSchema.putItem(267, "minecraft:iron_sword");
        StationFlatteningItemStackSchema.putItem(268, "minecraft:wooden_sword");
        StationFlatteningItemStackSchema.putItem(269, "minecraft:wooden_shovel");
        StationFlatteningItemStackSchema.putItem(270, "minecraft:wooden_pickaxe");
        StationFlatteningItemStackSchema.putItem(271, "minecraft:wooden_axe");
        StationFlatteningItemStackSchema.putItem(272, "minecraft:stone_sword");
        StationFlatteningItemStackSchema.putItem(273, "minecraft:stone_shovel");
        StationFlatteningItemStackSchema.putItem(274, "minecraft:stone_pickaxe");
        StationFlatteningItemStackSchema.putItem(275, "minecraft:stone_axe");
        StationFlatteningItemStackSchema.putItem(276, "minecraft:diamond_sword");
        StationFlatteningItemStackSchema.putItem(277, "minecraft:diamond_shovel");
        StationFlatteningItemStackSchema.putItem(278, "minecraft:diamond_pickaxe");
        StationFlatteningItemStackSchema.putItem(279, "minecraft:diamond_axe");
        StationFlatteningItemStackSchema.putItem(280, "minecraft:stick");
        StationFlatteningItemStackSchema.putItem(281, "minecraft:bowl");
        StationFlatteningItemStackSchema.putItem(282, "minecraft:mushroom_stew");
        StationFlatteningItemStackSchema.putItem(283, "minecraft:golden_sword");
        StationFlatteningItemStackSchema.putItem(284, "minecraft:golden_shovel");
        StationFlatteningItemStackSchema.putItem(285, "minecraft:golden_pickaxe");
        StationFlatteningItemStackSchema.putItem(286, "minecraft:golden_axe");
        StationFlatteningItemStackSchema.putItem(287, "minecraft:string");
        StationFlatteningItemStackSchema.putItem(288, "minecraft:feather");
        StationFlatteningItemStackSchema.putItem(289, "minecraft:gunpowder");
        StationFlatteningItemStackSchema.putItem(290, "minecraft:wooden_hoe");
        StationFlatteningItemStackSchema.putItem(291, "minecraft:stone_hoe");
        StationFlatteningItemStackSchema.putItem(292, "minecraft:iron_hoe");
        StationFlatteningItemStackSchema.putItem(293, "minecraft:diamond_hoe");
        StationFlatteningItemStackSchema.putItem(294, "minecraft:golden_hoe");
        StationFlatteningItemStackSchema.putItem(295, "minecraft:wheat_seeds");
        StationFlatteningItemStackSchema.putItem(296, "minecraft:wheat");
        StationFlatteningItemStackSchema.putItem(297, "minecraft:bread");
        StationFlatteningItemStackSchema.putItem(298, "minecraft:leather_helmet");
        StationFlatteningItemStackSchema.putItem(299, "minecraft:leather_chestplate");
        StationFlatteningItemStackSchema.putItem(300, "minecraft:leather_leggings");
        StationFlatteningItemStackSchema.putItem(301, "minecraft:leather_boots");
        StationFlatteningItemStackSchema.putItem(302, "minecraft:chainmail_helmet");
        StationFlatteningItemStackSchema.putItem(303, "minecraft:chainmail_chestplate");
        StationFlatteningItemStackSchema.putItem(304, "minecraft:chainmail_leggings");
        StationFlatteningItemStackSchema.putItem(305, "minecraft:chainmail_boots");
        StationFlatteningItemStackSchema.putItem(306, "minecraft:iron_helmet");
        StationFlatteningItemStackSchema.putItem(307, "minecraft:iron_chestplate");
        StationFlatteningItemStackSchema.putItem(308, "minecraft:iron_leggings");
        StationFlatteningItemStackSchema.putItem(309, "minecraft:iron_boots");
        StationFlatteningItemStackSchema.putItem(310, "minecraft:diamond_helmet");
        StationFlatteningItemStackSchema.putItem(311, "minecraft:diamond_chestplate");
        StationFlatteningItemStackSchema.putItem(312, "minecraft:diamond_leggings");
        StationFlatteningItemStackSchema.putItem(313, "minecraft:diamond_boots");
        StationFlatteningItemStackSchema.putItem(314, "minecraft:golden_helmet");
        StationFlatteningItemStackSchema.putItem(315, "minecraft:golden_chestplate");
        StationFlatteningItemStackSchema.putItem(316, "minecraft:golden_leggings");
        StationFlatteningItemStackSchema.putItem(317, "minecraft:golden_boots");
        StationFlatteningItemStackSchema.putItem(318, "minecraft:flint");
        StationFlatteningItemStackSchema.putItem(319, "minecraft:porkchop");
        StationFlatteningItemStackSchema.putItem(320, "minecraft:cooked_porkchop");
        StationFlatteningItemStackSchema.putItem(321, "minecraft:painting");
        StationFlatteningItemStackSchema.putItem(322, "minecraft:golden_apple");
        StationFlatteningItemStackSchema.putItem(323, "minecraft:oak_sign");
        StationFlatteningItemStackSchema.putItem(324, "minecraft:oak_door");
        StationFlatteningItemStackSchema.putItem(325, "minecraft:bucket");
        StationFlatteningItemStackSchema.putItem(326, "minecraft:water_bucket");
        StationFlatteningItemStackSchema.putItem(327, "minecraft:lava_bucket");
        StationFlatteningItemStackSchema.putItem(328, "minecraft:minecart");
        StationFlatteningItemStackSchema.putItem(329, "minecraft:saddle");
        StationFlatteningItemStackSchema.putItem(330, "minecraft:iron_door");
        StationFlatteningItemStackSchema.putItem(331, "minecraft:redstone");
        StationFlatteningItemStackSchema.putItem(332, "minecraft:snowball");
        StationFlatteningItemStackSchema.putItem(333, "minecraft:oak_boat");
        StationFlatteningItemStackSchema.putItem(334, "minecraft:leather");
        StationFlatteningItemStackSchema.putItem(335, "minecraft:milk_bucket");
        StationFlatteningItemStackSchema.putItem(336, "minecraft:brick");
        StationFlatteningItemStackSchema.putItem(337, "minecraft:clay_ball");
        StationFlatteningItemStackSchema.putItem(338, "minecraft:sugar_cane");
        StationFlatteningItemStackSchema.putItem(339, "minecraft:paper");
        StationFlatteningItemStackSchema.putItem(340, "minecraft:book");
        StationFlatteningItemStackSchema.putItem(341, "minecraft:slime_ball");
        StationFlatteningItemStackSchema.putItem(342, "minecraft:chest_minecart");
        StationFlatteningItemStackSchema.putItem(343, "minecraft:furnace_minecart");
        StationFlatteningItemStackSchema.putItem(344, "minecraft:egg");
        StationFlatteningItemStackSchema.putItem(345, "minecraft:compass");
        StationFlatteningItemStackSchema.putItem(346, "minecraft:fishing_rod");
        StationFlatteningItemStackSchema.putItem(347, "minecraft:clock");
        StationFlatteningItemStackSchema.putItem(348, "minecraft:glowstone_dust");
        StationFlatteningItemStackSchema.putItem(349, "minecraft:cod");
        StationFlatteningItemStackSchema.putItem(350, "minecraft:cooked_cod");
        StationFlatteningItemStackSchema.putItem(351, "minecraft:dye");
        StationFlatteningItemStackSchema.putItem(352, "minecraft:bone");
        StationFlatteningItemStackSchema.putItem(353, "minecraft:sugar");
        StationFlatteningItemStackSchema.putItem(354, "minecraft:cake");
        StationFlatteningItemStackSchema.putItem(355, "minecraft:red_bed");
        StationFlatteningItemStackSchema.putItem(356, "minecraft:repeater");
        StationFlatteningItemStackSchema.putItem(357, "minecraft:cookie");
        StationFlatteningItemStackSchema.putItem(358, "minecraft:map");
        StationFlatteningItemStackSchema.putItem(359, "minecraft:shears");
        StationFlatteningItemStackSchema.putItem(2256, "minecraft:music_disc_13");
        StationFlatteningItemStackSchema.putItem(2257, "minecraft:music_disc_cat");
    }
}

