/*
 * Decompiled with CFR 0.152.
 */
package net.modificationstation.stationapi.api.worldgen;

import it.unimi.dsi.fastutil.objects.Object2BooleanMap;
import it.unimi.dsi.fastutil.objects.Object2BooleanOpenHashMap;
import it.unimi.dsi.fastutil.objects.Reference2ObjectOpenHashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.class_153;
import net.minecraft.class_18;
import net.modificationstation.stationapi.api.StationAPI;
import net.modificationstation.stationapi.api.event.worldgen.biome.BiomeModificationEvent;
import net.modificationstation.stationapi.api.util.Identifier;
import net.modificationstation.stationapi.api.worldgen.biome.BiomeProvider;
import net.modificationstation.stationapi.api.worldgen.biome.BiomeRegionsProvider;
import net.modificationstation.stationapi.impl.world.StationDimension;
import net.modificationstation.stationapi.impl.worldgen.NetherBiomeProviderImpl;
import net.modificationstation.stationapi.impl.worldgen.OverworldBiomeProviderImpl;

public class BiomeAPI {
    private static Map<Identifier, BiomeProvider> overworldProviders = new Reference2ObjectOpenHashMap(16);
    private static Map<Identifier, BiomeProvider> netherProviders = new Reference2ObjectOpenHashMap(16);
    private static final Object2BooleanMap<class_18> MODIFICATIONS_APPLIED = new Object2BooleanOpenHashMap(16);
    private static BiomeRegionsProvider overworldProvider;
    private static BiomeRegionsProvider netherProvider;

    public static void addOverworldBiome(class_153 biome, float t1, float t2, float w1, float w2) {
        OverworldBiomeProviderImpl.getInstance().addBiome(biome, t1, t2, w1, w2);
    }

    public static void addOverworldBiomeProvider(Identifier id, BiomeProvider provider) {
        overworldProviders.put(id, provider);
    }

    public static BiomeProvider getOverworldBiomeProvider(Identifier id) {
        return overworldProviders.get(id);
    }

    public static void addNetherBiome(class_153 biome) {
        NetherBiomeProviderImpl.getInstance().addBiome(biome);
    }

    public static void addNetherBiomeProvider(Identifier id, BiomeProvider provider) {
        netherProviders.put(id, provider);
    }

    public static BiomeProvider getNetherBiomeProvider(Identifier id) {
        return netherProviders.get(id);
    }

    public static BiomeProvider getOverworldProvider() {
        return overworldProvider;
    }

    public static BiomeProvider getNetherProvider() {
        return netherProvider;
    }

    public static void init(class_18 world, long seed) {
        List<BiomeProvider> biomes;
        class_153.method_786((double)0.0, (double)0.0);
        if (overworldProvider == null) {
            biomes = overworldProviders.keySet().stream().sorted().map(overworldProviders::get).toList();
            overworldProvider = new BiomeRegionsProvider(biomes);
            overworldProviders = null;
        }
        if (netherProvider == null) {
            biomes = netherProviders.keySet().stream().sorted().map(netherProviders::get).toList();
            netherProvider = new BiomeRegionsProvider(biomes);
            netherProviders = null;
        }
        overworldProvider.setSeed(seed);
        netherProvider.setSeed(seed);
        if (!MODIFICATIONS_APPLIED.getBoolean((Object)world)) {
            MODIFICATIONS_APPLIED.put((Object)world, true);
            ((StationDimension)world.field_216).getBiomes().forEach(biome -> StationAPI.EVENT_BUS.post(((BiomeModificationEvent.BiomeModificationEventBuilder)((Object)((Object)((BiomeModificationEvent.BiomeModificationEventBuilder)((Object)((Object)BiomeModificationEvent.builder().biome((class_153)biome)))).world(world)))).build()));
        }
    }
}

