/*
 * Decompiled with CFR 0.152.
 */
package net.modificationstation.stationapi.api.worldgen.biome;

import it.unimi.dsi.fastutil.objects.Reference2IntMap;
import it.unimi.dsi.fastutil.objects.Reference2IntOpenHashMap;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_153;
import net.minecraft.class_239;
import net.minecraft.class_57;
import net.modificationstation.stationapi.api.worldgen.biome.BiomeColorProvider;
import net.modificationstation.stationapi.api.worldgen.biome.TemplateBiome;
import net.modificationstation.stationapi.api.worldgen.feature.DefaultFeatures;
import net.modificationstation.stationapi.api.worldgen.surface.SurfaceRule;
import net.modificationstation.stationapi.impl.worldgen.BiomeColorsImpl;

public class BiomeBuilder {
    private static final ThreadLocal<BiomeBuilder> INSTANCES = ThreadLocal.withInitial(BiomeBuilder::new);
    private final Reference2IntMap<Class<? extends class_57>> hostileEntities = new Reference2IntOpenHashMap(32);
    private final Reference2IntMap<Class<? extends class_57>> passiveEntities = new Reference2IntOpenHashMap(32);
    private final Reference2IntMap<Class<? extends class_57>> waterEntities = new Reference2IntOpenHashMap(32);
    private final List<class_239> features = new ArrayList<class_239>();
    private final List<SurfaceRule> rules = new ArrayList<SurfaceRule>();
    private BiomeColorProvider grassColor;
    private BiomeColorProvider leavesColor;
    private BiomeColorProvider fogColor;
    private boolean noDimensionFeatures;
    private boolean precipitation;
    private boolean snow;
    private String name;
    private int minHeight;
    private int maxHeight;

    private BiomeBuilder() {
    }

    public static BiomeBuilder start(String name) {
        BiomeBuilder instance = INSTANCES.get();
        instance.name = name;
        instance.noDimensionFeatures = false;
        instance.precipitation = true;
        instance.snow = false;
        instance.minHeight = 40;
        instance.maxHeight = 128;
        instance.grassColor = BiomeColorsImpl.DEFAULT_GRASS_COLOR;
        instance.leavesColor = BiomeColorsImpl.DEFAULT_LEAVES_COLOR;
        instance.fogColor = BiomeColorsImpl.DEFAULT_FOG_COLOR;
        instance.hostileEntities.clear();
        instance.passiveEntities.clear();
        instance.waterEntities.clear();
        instance.features.clear();
        instance.rules.clear();
        return instance;
    }

    public BiomeBuilder surfaceRule(SurfaceRule rule) {
        this.rules.add(rule);
        return this;
    }

    public BiomeBuilder noDimensionFeatures() {
        this.noDimensionFeatures = true;
        return this;
    }

    public BiomeBuilder feature(class_239 feature) {
        this.features.add(feature);
        return this;
    }

    public BiomeBuilder overworldLakes() {
        this.feature(DefaultFeatures.WATER_LAKE_SCATTERED);
        this.feature(DefaultFeatures.LAVA_LAKE_SCATTERED);
        return this;
    }

    public BiomeBuilder overworldOres() {
        this.feature(DefaultFeatures.DIRT_ORE_SCATTERED);
        this.feature(DefaultFeatures.GRAVEL_ORE_SCATTERED);
        this.feature(DefaultFeatures.COAL_ORE_SCATTERED);
        this.feature(DefaultFeatures.IRON_ORE_SCATTERED);
        this.feature(DefaultFeatures.GOLD_ORE_SCATTERED);
        this.feature(DefaultFeatures.REDSTONE_ORE_SCATTERED);
        this.feature(DefaultFeatures.DIAMOND_ORE_SCATTERED);
        this.feature(DefaultFeatures.LAPIS_LAZULI_ORE_SCATTERED);
        return this;
    }

    public BiomeBuilder precipitation(boolean precipitation) {
        this.precipitation = precipitation;
        return this;
    }

    public BiomeBuilder snow(boolean snow) {
        this.snow = snow;
        return this;
    }

    public BiomeBuilder hostileEntity(Class<? extends class_57> entity, int rarity) {
        this.hostileEntities.put(entity, rarity);
        return this;
    }

    public BiomeBuilder passiveEntity(Class<? extends class_57> entity, int rarity) {
        this.passiveEntities.put(entity, rarity);
        return this;
    }

    public BiomeBuilder waterEntity(Class<? extends class_57> entity, int rarity) {
        this.waterEntities.put(entity, rarity);
        return this;
    }

    public BiomeBuilder grassColor(BiomeColorProvider provider) {
        this.grassColor = provider;
        return this;
    }

    public BiomeBuilder grassColor(int color) {
        return this.grassColor((source, x, z) -> color);
    }

    public BiomeBuilder leavesColor(BiomeColorProvider provider) {
        this.leavesColor = provider;
        return this;
    }

    public BiomeBuilder leavesColor(int color) {
        return this.leavesColor((source, x, z) -> color);
    }

    public BiomeBuilder grassAndLeavesColor(BiomeColorProvider provider) {
        this.grassColor(provider);
        this.leavesColor(provider);
        return this;
    }

    public BiomeBuilder grassAndLeavesColor(int color) {
        return this.grassAndLeavesColor((source, x, z) -> color);
    }

    public BiomeBuilder fogColor(BiomeColorProvider provider) {
        this.fogColor = provider;
        return this;
    }

    public BiomeBuilder fogColor(int color) {
        return this.fogColor((source, x, z) -> color);
    }

    public BiomeBuilder height(int minHeight, int maxHeight) {
        this.minHeight = minHeight;
        this.maxHeight = maxHeight;
        return this;
    }

    public class_153 build() {
        TemplateBiome biome = new TemplateBiome(this.name);
        this.rules.forEach(arg_0 -> biome.addSurfaceRule(arg_0));
        biome.setPrecipitation(this.precipitation);
        biome.setSnow(this.snow);
        biome.setGrassColor(this.grassColor);
        biome.setLeavesColor(this.leavesColor);
        biome.setFogColor(this.fogColor);
        biome.setMinHeight(this.minHeight);
        biome.setMaxHeight(this.maxHeight);
        biome.setNoDimensionFeatures(this.noDimensionFeatures);
        this.hostileEntities.forEach((arg_0, arg_1) -> biome.addHostileEntity(arg_0, arg_1));
        this.passiveEntities.forEach((arg_0, arg_1) -> biome.addPassiveEntity(arg_0, arg_1));
        this.waterEntities.forEach((arg_0, arg_1) -> biome.addWaterEntity(arg_0, arg_1));
        biome.getFeatures().addAll(this.features);
        return biome;
    }
}

