/*
 * Decompiled with CFR 0.152.
 */
package net.modificationstation.stationapi.api.worldgen.biome;

import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Random;
import net.minecraft.class_153;
import net.minecraft.class_458;
import net.modificationstation.stationapi.api.worldgen.biome.BiomeProvider;
import net.modificationstation.stationapi.impl.worldgen.IDVoronoiNoise;

public class VoronoiBiomeProvider
implements BiomeProvider {
    private final List<class_153> biomes = new ArrayList<class_153>();
    private final double[] buffer = new double[1];
    private IDVoronoiNoise idNoise;
    private class_458 distortX;
    private class_458 distortZ;
    private final double distortion;
    private final double s1;
    private final double s2;

    public VoronoiBiomeProvider() {
        this(100.0, 0.1);
    }

    public VoronoiBiomeProvider(double scale) {
        this(scale, 0.1);
    }

    public VoronoiBiomeProvider(double scale, double distortion) {
        this.distortion = distortion;
        this.s1 = 1.0 / scale;
        this.s2 = this.s1 * 10.0;
    }

    public void addBiome(class_153 biome) {
        this.biomes.add(biome);
    }

    @Override
    public class_153 getBiome(int x, int z, float temperature, float downfall) {
        double px = (double)x * this.s1 + this.distortX.method_1516(this.buffer, (double)x, (double)z, 1, 1, this.s2, this.s2, 0.25)[0] * this.distortion;
        double pz = (double)z * this.s1 + this.distortZ.method_1516(this.buffer, (double)x, (double)z, 1, 1, this.s2, this.s2, 0.25)[0] * this.distortion;
        int id = this.idNoise.getID(px, pz, this.biomes.size());
        return this.biomes.get(id);
    }

    @Override
    public Collection<class_153> getBiomes() {
        ObjectOpenHashSet biomes = new ObjectOpenHashSet();
        biomes.addAll(this.biomes);
        return biomes;
    }

    @Override
    public void setSeed(long seed) {
        Random random = new Random(seed);
        this.idNoise = new IDVoronoiNoise(random.nextInt());
        this.distortX = new class_458(new Random(random.nextLong()), 2);
        this.distortZ = new class_458(new Random(random.nextLong()), 2);
    }
}

