/*
 * Decompiled with CFR 0.152.
 */
package net.modificationstation.stationapi.api.worldgen.surface;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_17;
import net.modificationstation.stationapi.api.block.BlockState;
import net.modificationstation.stationapi.api.tag.TagKey;
import net.modificationstation.stationapi.api.util.math.Direction;
import net.modificationstation.stationapi.api.worldgen.surface.StateSurfaceRule;
import net.modificationstation.stationapi.api.worldgen.surface.SurfaceRule;
import net.modificationstation.stationapi.api.worldgen.surface.condition.BlockSurfaceCondition;
import net.modificationstation.stationapi.api.worldgen.surface.condition.DepthSurfaceCondition;
import net.modificationstation.stationapi.api.worldgen.surface.condition.HeightSurfaceCondition;
import net.modificationstation.stationapi.api.worldgen.surface.condition.SlopeSurfaceCondition;
import net.modificationstation.stationapi.api.worldgen.surface.condition.StateSurfaceCondition;
import net.modificationstation.stationapi.api.worldgen.surface.condition.SurfaceCondition;
import net.modificationstation.stationapi.api.worldgen.surface.condition.TagSurfaceCondition;

public class SurfaceBuilder {
    private static final ThreadLocal<SurfaceBuilder> INSTANCES = ThreadLocal.withInitial(SurfaceBuilder::new);
    private final List<ConditionInfo> conditions = new ArrayList<ConditionInfo>();
    private SurfaceRule rule;

    private SurfaceBuilder() {
    }

    public static SurfaceBuilder start(SurfaceRule rule) {
        SurfaceBuilder instance = INSTANCES.get();
        instance.rule = rule;
        return instance;
    }

    public static SurfaceBuilder start(BlockState state) {
        return SurfaceBuilder.start(new StateSurfaceRule(state));
    }

    public static SurfaceBuilder start(class_17 block) {
        return SurfaceBuilder.start(new StateSurfaceRule(block.getDefaultState()));
    }

    public SurfaceBuilder condition(SurfaceCondition condition, int priority) {
        this.conditions.add(new ConditionInfo(condition, priority));
        return this;
    }

    public SurfaceBuilder ground(int depth) {
        return this.condition(new DepthSurfaceCondition(depth, Direction.AxisDirection.NEGATIVE), 1);
    }

    public SurfaceBuilder ground(int minDepth, int maxDepth) {
        return this.condition(new DepthSurfaceCondition(minDepth, maxDepth, Direction.AxisDirection.NEGATIVE), 2);
    }

    public SurfaceBuilder ceiling(int depth) {
        return this.condition(new DepthSurfaceCondition(depth, Direction.AxisDirection.POSITIVE), 1);
    }

    public SurfaceBuilder ceiling(int minDepth, int maxDepth) {
        return this.condition(new DepthSurfaceCondition(minDepth, maxDepth, Direction.AxisDirection.POSITIVE), 2);
    }

    public SurfaceBuilder slope(float angle) {
        return this.condition(new SlopeSurfaceCondition(angle, true, true), 3);
    }

    public SurfaceBuilder slope(float angle, boolean greater) {
        return this.condition(new SlopeSurfaceCondition(angle, true, greater), 3);
    }

    public SurfaceBuilder slope(float angle, boolean degrees, boolean greater) {
        return this.condition(new SlopeSurfaceCondition(angle, degrees, greater), 3);
    }

    public SurfaceBuilder replace(BlockState filter) {
        return this.condition(new StateSurfaceCondition(filter), 4);
    }

    public SurfaceBuilder replace(class_17 filter) {
        return this.condition(new BlockSurfaceCondition(filter), 4);
    }

    public SurfaceBuilder replace(TagKey<class_17> filter) {
        return this.condition(new TagSurfaceCondition(filter), 4);
    }

    public SurfaceBuilder range(int minY, int maxY) {
        return this.condition(new HeightSurfaceCondition(minY, maxY), 0);
    }

    public SurfaceRule build() {
        this.conditions.stream().sorted().forEach(info -> this.rule.addCondition(info.condition));
        this.conditions.clear();
        return this.rule;
    }

    private record ConditionInfo(SurfaceCondition condition, int priority) implements Comparable<ConditionInfo>
    {
        @Override
        public int compareTo(ConditionInfo info) {
            return Integer.compare(this.priority, info.priority);
        }
    }
}

