/*
 * Decompiled with CFR 0.152.
 */
package net.modificationstation.stationapi.api.worldgen.surface.condition;

import java.util.Random;
import net.minecraft.class_18;
import net.minecraft.class_458;
import net.modificationstation.stationapi.api.block.BlockState;
import net.modificationstation.stationapi.api.util.math.Direction;
import net.modificationstation.stationapi.api.util.math.MathHelper;
import net.modificationstation.stationapi.api.worldgen.surface.condition.SurfaceCondition;

public class DepthSurfaceCondition
implements SurfaceCondition {
    private static final class_458 NOISE = new class_458(new Random(0L), 2);
    private static final double[] BUFFER = new double[1];
    private final Direction.AxisDirection direction;
    private final int minDepth;
    private final int maxDepth;

    public DepthSurfaceCondition(int depth, Direction.AxisDirection direction) {
        this(depth, depth, direction);
    }

    public DepthSurfaceCondition(int minDepth, int maxDepth, Direction.AxisDirection direction) {
        this.direction = direction;
        this.minDepth = minDepth;
        this.maxDepth = maxDepth;
    }

    @Override
    public boolean canApply(class_18 world, int x, int y, int z, BlockState state) {
        int depth = this.minDepth;
        if (this.minDepth != this.maxDepth) {
            depth = MathHelper.lerp((double)NOISE.method_1516(BUFFER, (double)x, (double)z, 1, 1, 0.1, 0.1, 0.25)[0], (int)this.minDepth, (int)this.maxDepth);
        }
        return (state = world.getBlockState(x, y - depth * this.direction.offset(), z)).isAir() || state.getMaterial().method_893() || state.getMaterial().method_896() || !state.getMaterial().method_907();
    }
}

