/*
 * Decompiled with CFR 0.152.
 */
package net.modificationstation.stationapi.api.worldgen.surface.condition;

import net.minecraft.class_18;
import net.modificationstation.stationapi.api.block.BlockState;
import net.modificationstation.stationapi.api.util.math.Vec3f;
import net.modificationstation.stationapi.api.worldgen.surface.condition.SurfaceCondition;

public class SlopeSurfaceCondition
implements SurfaceCondition {
    private final Vec3f a = new Vec3f();
    private final Vec3f b = new Vec3f();
    private final boolean greater;
    private final float angle;

    public SlopeSurfaceCondition(float angle, boolean degrees, boolean greater) {
        this.angle = degrees ? (float)Math.toRadians(angle) : angle;
        this.greater = greater;
    }

    @Override
    public boolean canApply(class_18 world, int x, int y, int z, BlockState state) {
        this.a.set(2.0f, (float)(world.method_222(x + 1, z) - world.method_222(x - 1, z)), 0.0f);
        this.a.normalize();
        this.b.set(0.0f, (float)(world.method_222(x, z + 1) - world.method_222(x, z - 1)), 2.0f);
        this.b.normalize();
        this.a.cross(this.b);
        this.a.normalize();
        this.b.set(this.a.getX(), 0.0f, this.a.getZ());
        this.b.normalize();
        float dot = this.a.dot(this.b);
        return this.greater ? this.angle < dot : this.angle > dot;
    }
}

