/*
 * Decompiled with CFR 0.152.
 */
package net.modificationstation.stationapi.impl.worldgen;

import java.util.function.Function;
import net.minecraft.class_153;
import net.minecraft.class_189;
import net.minecraft.class_519;
import net.modificationstation.stationapi.api.util.math.MathHelper;
import net.modificationstation.stationapi.api.worldgen.biome.BiomeColorProvider;

public class BiomeColorInterpolator {
    private final Function<class_153, BiomeColorProvider> provider;
    private final int[] colors = new int[4];
    private final int bitShift;
    private final int side;
    private boolean initiated;
    private int lastX;
    private int lastZ;

    public BiomeColorInterpolator(Function<class_153, BiomeColorProvider> provider, int side) {
        this.side = side;
        this.bitShift = class_189.method_645((double)(Math.log(side) / Math.log(2.0)));
        this.provider = provider;
    }

    public int getColor(class_519 source, double x, double z) {
        int x1 = class_189.method_645((double)(x / (double)this.side));
        int z1 = class_189.method_645((double)(z / (double)this.side));
        float dx = (float)(x / (double)this.side - (double)x1);
        float dz = (float)(z / (double)this.side - (double)z1);
        if (!this.initiated || x1 != this.lastX || z1 != this.lastZ) {
            this.initiated = true;
            this.lastX = x1;
            this.lastZ = z1;
            int x2 = (x1 <<= this.bitShift) + this.side;
            int z2 = (z1 <<= this.bitShift) + this.side;
            this.colors[0] = this.provider.apply(source.method_1787(x1, z1)).getColor(source, x1, z1);
            this.colors[1] = this.provider.apply(source.method_1787(x2, z1)).getColor(source, x2, z1);
            this.colors[2] = this.provider.apply(source.method_1787(x1, z2)).getColor(source, x1, z2);
            this.colors[3] = this.provider.apply(source.method_1787(x2, z2)).getColor(source, x2, z2);
        }
        int a = this.lerp(this.colors[0], this.colors[1], dx);
        int b = this.lerp(this.colors[2], this.colors[3], dx);
        return this.lerp(a, b, dz);
    }

    private int lerp(int a, int b, float delta) {
        float r1 = (float)(a >> 16 & 0xFF) / 255.0f;
        float r2 = (float)(b >> 16 & 0xFF) / 255.0f;
        float g1 = (float)(a >> 8 & 0xFF) / 255.0f;
        float g2 = (float)(b >> 8 & 0xFF) / 255.0f;
        float b1 = (float)(a & 0xFF) / 255.0f;
        float b2 = (float)(b & 0xFF) / 255.0f;
        r1 = MathHelper.lerp((double)delta, (float)r1, (float)r2);
        g1 = MathHelper.lerp((double)delta, (float)g1, (float)g2);
        b1 = MathHelper.lerp((double)delta, (float)b1, (float)b2);
        int ir = (int)(r1 * 255.0f);
        int ig = (int)(g1 * 255.0f);
        int ib = (int)(b1 * 255.0f);
        return 0xFF000000 | ir << 16 | ig << 8 | ib;
    }
}

