/*
 * Decompiled with CFR 0.152.
 */
package net.modificationstation.stationapi.impl.worldgen;

import java.util.function.Function;
import net.minecraft.class_153;
import net.minecraft.class_189;
import net.minecraft.class_519;
import net.modificationstation.stationapi.api.util.math.MathHelper;

public class BiomeDataInterpolator {
    private final Function<class_153, Number> provider;
    private final float[] data = new float[4];
    private final int bitShift;
    private final int side;
    private final int radius;
    private final int count;
    private final int distance;
    private boolean initiated;
    private int lastX;
    private int lastZ;

    public BiomeDataInterpolator(Function<class_153, Number> provider, int side, int radius, int distance) {
        this.side = side;
        this.radius = radius;
        this.distance = distance;
        this.count = (radius << 1 | 1) * (radius << 1 | 1);
        this.bitShift = class_189.method_645((double)(Math.log(side) / Math.log(2.0)));
        this.provider = provider;
    }

    public float get(class_519 source, int x, int z) {
        int x1 = x >> this.bitShift;
        int z1 = z >> this.bitShift;
        float dx = (float)(x - (x1 << this.bitShift)) / (float)this.side;
        float dz = (float)(z - (z1 << this.bitShift)) / (float)this.side;
        if (!this.initiated || x1 != this.lastX || z1 != this.lastZ) {
            this.initiated = true;
            this.lastX = x1;
            this.lastZ = z1;
            int x2 = (x1 <<= this.bitShift) + this.side;
            int z2 = (z1 <<= this.bitShift) + this.side;
            this.data[0] = this.getInArea(source, x1, z1);
            this.data[1] = this.getInArea(source, x2, z1);
            this.data[2] = this.getInArea(source, x1, z2);
            this.data[3] = this.getInArea(source, x2, z2);
        }
        float a = MathHelper.lerp((double)dx, (float)this.data[0], (float)this.data[1]);
        float b = MathHelper.lerp((double)dx, (float)this.data[2], (float)this.data[3]);
        return MathHelper.lerp((double)dz, (float)a, (float)b);
    }

    private float getInArea(class_519 source, int x, int z) {
        float value = 0.0f;
        for (int dx = -this.radius; dx <= this.radius; ++dx) {
            for (int dz = -this.radius; dz <= this.radius; ++dz) {
                class_153 biome = source.method_1787(x + dx * this.distance, z + dz * this.distance);
                value += this.provider.apply(biome).floatValue();
            }
        }
        return value / (float)this.count;
    }
}

