/*
 * Decompiled with CFR 0.152.
 */
package net.modificationstation.stationapi.impl.worldgen;

import net.minecraft.class_189;
import net.minecraft.class_519;
import net.minecraft.client.Minecraft;
import net.modificationstation.stationapi.api.util.math.MathHelper;
import net.modificationstation.stationapi.impl.worldgen.BiomeColorsImpl;

public class FogRendererImpl {
    private static final float[] FOG_COLOR = new float[3];

    public static void setupFog(Minecraft minecraft, float delta) {
        class_519 biomeSource = minecraft.field_2804.method_1781();
        double x = minecraft.field_2807.field_1600;
        double z = minecraft.field_2807.field_1602;
        int color = BiomeColorsImpl.FOG_INTERPOLATOR.getColor(biomeSource, x, z);
        FogRendererImpl.FOG_COLOR[0] = (float)(color >> 16 & 0xFF) / 255.0f;
        FogRendererImpl.FOG_COLOR[1] = (float)(color >> 8 & 0xFF) / 255.0f;
        FogRendererImpl.FOG_COLOR[2] = (float)(color & 0xFF) / 255.0f;
        if (minecraft.field_2804.field_216.field_2177) {
            return;
        }
        delta = minecraft.field_2804.method_198(delta);
        delta = class_189.method_646((float)(delta * (float)Math.PI * 2.0f)) * 2.0f + 0.5f;
        delta = MathHelper.clamp((float)delta, (float)0.0f, (float)1.0f);
        FogRendererImpl.FOG_COLOR[0] = MathHelper.lerp((double)delta, (float)0.06f, (float)FOG_COLOR[0]);
        FogRendererImpl.FOG_COLOR[1] = MathHelper.lerp((double)delta, (float)0.06f, (float)FOG_COLOR[1]);
        FogRendererImpl.FOG_COLOR[2] = MathHelper.lerp((double)delta, (float)0.09f, (float)FOG_COLOR[2]);
    }

    public static float getR() {
        return FOG_COLOR[0];
    }

    public static float getG() {
        return FOG_COLOR[1];
    }

    public static float getB() {
        return FOG_COLOR[2];
    }
}

