/*
 * Decompiled with CFR 0.152.
 */
package net.modificationstation.stationapi.impl.worldgen;

import net.minecraft.class_18;
import net.minecraft.class_519;
import net.modificationstation.stationapi.api.worldgen.biome.StationBiome;
import net.modificationstation.stationapi.impl.worldgen.BiomeDataInterpolator;

public class WorldGeneratorImpl {
    private static final BiomeDataInterpolator MIN_HEIGHT_INTERPOLATOR = new BiomeDataInterpolator(StationBiome::getMinHeight, 16, 4, 8);
    private static final BiomeDataInterpolator MAX_HEIGHT_INTERPOLATOR = new BiomeDataInterpolator(StationBiome::getMaxHeight, 16, 4, 8);

    public static void updateNoise(class_18 world, int cx, int cz, double[] data) {
        float min = 0.0f;
        float max = 0.0f;
        float n = 0.0f;
        cx <<= 4;
        cz <<= 4;
        class_519 biomeSource = world.method_1781();
        int sideY = data.length / 25;
        int dx = sideY * 5;
        for (int i = 0; i < data.length; ++i) {
            int y = i % sideY;
            if (y == 0) {
                int x = (i / dx << 2) + cx;
                int z = (i / sideY % 5 << 2) + cz;
                min = MIN_HEIGHT_INTERPOLATOR.get(biomeSource, x, z) / 8.0f;
                max = MAX_HEIGHT_INTERPOLATOR.get(biomeSource, x, z) / 8.0f;
            }
            if ((float)(y += world.getBottomY()) < min) {
                float d = (min - (float)y) * 100.0f + n * 10.0f;
                data[i] = WorldGeneratorImpl.smoothMax(data[i], d, 1.0);
                continue;
            }
            if (!((float)y > max)) continue;
            float d = (max - (float)y) * 100.0f + n * 10.0f;
            data[i] = WorldGeneratorImpl.smoothMin(data[i], d, 1.0);
        }
    }

    private static double smoothMax(double a, double b, double k) {
        return -WorldGeneratorImpl.smoothMin(-a, -b, k);
    }

    private static double smoothMin(double a, double b, double k) {
        double h = Math.max(k - Math.abs(a - b), 0.0) / k;
        return Math.min(a, b) - h * h * k * 0.25;
    }
}

