/*
 * Decompiled with CFR 0.152.
 */
package net.modificationstation.stationapi.api.resource;

import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.fabricmc.loader.api.FabricLoader;
import net.modificationstation.stationapi.api.resource.RecursiveReader;
import net.modificationstation.stationapi.api.util.Identifier;
import net.modificationstation.stationapi.api.util.Namespace;

@Deprecated
public class ResourceHelper {
    public static final ResourceHelper ASSETS = new ResourceHelper("/assets");
    public static final ResourceHelper DATA = new ResourceHelper("/data");
    public final String rootPath;

    public ResourceHelper(String rootPath) {
        this.rootPath = rootPath;
    }

    public boolean contains(String path) {
        String startsWith = this.rootPath + "/";
        return path.startsWith(startsWith);
    }

    public String toPath(Identifier identifier, String subPath, String extension) {
        identifier = subPath.isEmpty() ? identifier : identifier.withPrefixedPath(subPath + "/");
        return this.toPath(extension.isEmpty() ? identifier : identifier.withSuffixedPath("." + extension));
    }

    public String toPath(Identifier identifier) {
        return identifier.namespace == Namespace.MINECRAFT && identifier.path.startsWith("/") ? identifier.path : this.rootPath + "/" + identifier.namespace + "/" + identifier.path;
    }

    public Identifier toId(String path, String subPath, String extension) {
        if (!((String)path).startsWith("/")) {
            path = "/" + (String)path;
        }
        if (!this.contains((String)path)) {
            throw new IllegalArgumentException("The path \"" + (String)path + "\" doesn't start with the current ResourceManager's root path \"" + this.rootPath + "\"!");
        }
        if (!((String)path).endsWith("." + extension)) {
            throw new IllegalArgumentException("The path \"" + (String)path + "\" doesn't end with the specified file extension \"" + extension + "\"!");
        }
        int indexOfSubpath = ((String)(path = ((String)path).substring((this.rootPath + "/").length()))).indexOf("/");
        if (indexOfSubpath == -1) {
            throw new IllegalArgumentException("The path \"" + (String)path + "\" doesn't have a namespace!");
        }
        Namespace namespace = Namespace.of(((String)path).substring(0, indexOfSubpath));
        int indexOfId = indexOfSubpath + 1 + subPath.length();
        String subPathCheck = ((String)path).substring(indexOfSubpath + 1, indexOfId);
        if (!subPathCheck.equals(subPath)) {
            throw new IllegalArgumentException("The path \"" + (String)path + "\" doesn't have a matching subpath \"" + subPath + "\" after namespace!");
        }
        String id = ((String)path).substring(indexOfId + 1);
        return Identifier.of(namespace, id.substring(0, id.length() - extension.length() - 1));
    }

    public Set<URL> find(String path, Predicate<String> filter) {
        return FabricLoader.getInstance().getAllMods().stream().map(modContainer -> this.find(Namespace.of(modContainer), path, filter)).flatMap(Collection::stream).collect(Collectors.toSet());
    }

    public Set<URL> find(Namespace namespace, String path, Predicate<String> filter) {
        if (ResourceHelper.class.getResource((String)(path = this.rootPath + "/" + namespace + "/" + (String)path)) != null) {
            try {
                return new RecursiveReader((String)path, filter).read();
            }
            catch (IOException | URISyntaxException e) {
                throw new RuntimeException(e);
            }
        }
        return Collections.emptySet();
    }
}

