/*
 * Decompiled with CFR 0.152.
 */
package net.modificationstation.stationapi.api.util;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import java.util.function.Function;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.fabricmc.loader.api.Version;
import net.fabricmc.loader.api.metadata.ModMetadata;
import net.modificationstation.stationapi.api.util.Identifier;
import net.modificationstation.stationapi.api.util.exception.MissingModException;
import org.jetbrains.annotations.NotNull;

public final class Namespace
implements Comparable<Namespace> {
    private static final boolean CHECK_MISSING_MODS = false;
    @NotNull
    private static final @NotNull Cache<@NotNull String, @NotNull Namespace> CACHE = Caffeine.newBuilder().softValues().build();
    @NotNull
    private static final @NotNull Function<@NotNull String, @NotNull Namespace> NAMESPACE_FACTORY = Namespace::new;
    @NotNull
    public static final Namespace MINECRAFT = Namespace.of("minecraft");
    @NotNull
    private final String namespace;
    private final int hashCode;

    @NotNull
    public static Namespace of(@NotNull ModContainer modContainer) {
        return Namespace.of(modContainer.getMetadata());
    }

    @NotNull
    public static Namespace of(@NotNull ModMetadata modMetadata) {
        return Namespace.of(modMetadata.getId());
    }

    @NotNull
    public static Namespace of(@NotNull String namespace) {
        return (Namespace)CACHE.get((Object)namespace, NAMESPACE_FACTORY);
    }

    private Namespace(@NotNull String namespace) {
        this.namespace = namespace;
        this.hashCode = this.toString().hashCode();
    }

    @NotNull
    public ModContainer getContainer() {
        return (ModContainer)FabricLoader.getInstance().getModContainer(this.namespace).orElseThrow(() -> new MissingModException(this.namespace));
    }

    @NotNull
    public ModMetadata getMetadata() {
        return this.getContainer().getMetadata();
    }

    @NotNull
    public String getName() {
        return this.getMetadata().getName();
    }

    @NotNull
    public Version getVersion() {
        return this.getMetadata().getVersion();
    }

    @NotNull
    public Identifier id(@NotNull String id) {
        return Identifier.of(this, id);
    }

    public boolean equals(@NotNull Object other) {
        if (this == other) {
            return true;
        }
        if (other instanceof Namespace) {
            @NotNull Namespace otherNamespace = (Namespace)other;
            if (this.namespace.equals(otherNamespace.namespace)) {
                throw new IllegalStateException(String.format("Encountered a duplicate instance of Namespace %s!", this.namespace));
            }
            return false;
        }
        return this.namespace.equals(other);
    }

    @NotNull
    public String toString() {
        return this.namespace;
    }

    public int hashCode() {
        return this.hashCode;
    }

    @Override
    public int compareTo(@NotNull Namespace o) {
        return this.namespace.compareTo(o.namespace);
    }
}

