/*
 * Decompiled with CFR 0.152.
 */
package net.modificationstation.stationapi.api.util;

import java.lang.annotation.Annotation;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.function.Function;
import net.modificationstation.stationapi.api.util.UnsafeProvider;
import sun.misc.Unsafe;

public class ReflectionHelper {
    private static final VarHandle modifiers;

    public static void setFieldsWithAnnotation(Object target, Class<? extends Annotation> annotation, Object value) throws IllegalAccessException {
        ReflectionHelper.setFieldsWithAnnotation(target.getClass(), target, annotation, value);
    }

    public static void setFieldsWithAnnotation(Class<?> targetClass, Object target, Class<? extends Annotation> annotation, Object value) throws IllegalAccessException {
        ReflectionHelper.setFieldsWithAnnotation(targetClass, target, annotation, (T annotation1) -> value);
    }

    public static <T extends Annotation> void setFieldsWithAnnotation(Object target, Class<T> annotation, Function<T, Object> processor) throws IllegalAccessException {
        ReflectionHelper.setFieldsWithAnnotation(target.getClass(), target, annotation, processor);
    }

    public static <T extends Annotation> void setFieldsWithAnnotation(Class<?> targetClass, Object target, Class<T> annotation, Function<T, Object> processor) throws IllegalAccessException {
        for (Field field : ReflectionHelper.getFieldsWithAnnotation(targetClass, annotation)) {
            ReflectionHelper.setPrivateFinalField(field, target, processor.apply(field.getAnnotation(annotation)));
        }
    }

    public static Field[] getFieldsWithAnnotation(Class<?> targetClass, Class<? extends Annotation> annotationClass) {
        Field[] fields = new Field[]{};
        for (Field field : targetClass.getDeclaredFields()) {
            if (field.getAnnotation(annotationClass) == null) continue;
            fields = Arrays.copyOf(fields, fields.length + 1);
            fields[fields.length - 1] = field;
        }
        return fields;
    }

    public static void setPrivateFinalField(Field field, Object instance, Object value) throws IllegalAccessException {
        int mod = field.getModifiers();
        ReflectionHelper.setPrivateField(modifiers, (Object)field, (Object)(mod & 0xFFFFFFEF));
        ReflectionHelper.setPrivateField(field, instance, value);
        ReflectionHelper.setPrivateField(modifiers, (Object)field, (Object)mod);
    }

    public static void setPrivateField(Field field, Object instance, Object value) throws IllegalAccessException {
        boolean inaccessible;
        boolean bl = inaccessible = !field.isAccessible();
        if (inaccessible) {
            field.setAccessible(true);
        }
        field.set(instance, value);
        if (inaccessible) {
            field.setAccessible(false);
        }
    }

    public static void setPrivateField(VarHandle var, Object instance, Object value) {
        var.set(instance, value);
    }

    static {
        try {
            Unsafe unsafe = UnsafeProvider.theUnsafe;
            Field implLookupField = MethodHandles.Lookup.class.getDeclaredField("IMPL_LOOKUP");
            MethodHandles.Lookup lookup = (MethodHandles.Lookup)unsafe.getObject(unsafe.staticFieldBase(implLookupField), unsafe.staticFieldOffset(implLookupField));
            modifiers = lookup.findVarHandle(Field.class, "modifiers", Integer.TYPE);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            throw new RuntimeException(e);
        }
    }
}

