package net.zekromaster.minecraft.ironchests

import net.minecraft.block.Block
import net.minecraft.item.Item
import net.modificationstation.stationapi.api.registry.tag.ItemTags
import net.modificationstation.stationapi.api.util.Identifier
import net.modificationstation.stationapi.api.util.Namespace
import net.zekromaster.minecraft.ironchests.IronChestsBlockEntrypoint.DIAMOND_CHEST
import net.zekromaster.minecraft.ironchests.IronChestsBlockEntrypoint.GOLD_CHEST
import net.zekromaster.minecraft.ironchests.IronChestsBlockEntrypoint.IRON_CHEST

private val LOOKUP: MutableMap<Identifier, IronChestMaterial> = mutableMapOf()

class IronChestMaterial(
    val id: Identifier,
    val rows: Int,
    val columns: Int,
    val displayName: String,
    private val craftingMaterialProvider: () -> Any,
    private val blockProvider: () -> Block,
) {

    val size = rows * columns
    val chestName: String = "$displayName Chest"

    val block
        get(): Block = blockProvider()

    val craftingMaterial
        get(): Any = craftingMaterialProvider()

    init {
        LOOKUP[id] = this
    }

    fun createBlockEntity() =
        IronChestBlockEntity(this)

    companion object {
        val WOOD = IronChestMaterial(
            id = Namespace.MINECRAFT.id("wood"),
            rows = 3,
            columns = 9,
            displayName = "Wood",
            craftingMaterialProvider = { ItemTags.PLANKS },
            blockProvider = { Block.CHEST }
        )

        // Had to use the MINECRAFT namespace for vanilla materials for backwards compatibility
        @JvmStatic
        val IRON = IronChestMaterial(
            id = Namespace.MINECRAFT.id("iron"),
            rows = 6,
            columns = 9,
            displayName = "Iron",
            craftingMaterialProvider = { Item.IRON_INGOT },
            blockProvider = { IRON_CHEST }
        )
        @JvmStatic
        val GOLD = IronChestMaterial(
            id = Namespace.MINECRAFT.id("gold"),
            rows = 9,
            columns = 9,
            displayName = "Gold",
            craftingMaterialProvider = { Item.GOLD_INGOT },
            blockProvider = { GOLD_CHEST }
        )
        @JvmStatic
        val DIAMOND = IronChestMaterial(
            id = Namespace.MINECRAFT.id("diamond"),
            rows = 9,
            columns = 12,
            displayName = "Diamond",
            craftingMaterialProvider = { Item.DIAMOND },
            blockProvider = { DIAMOND_CHEST }
        )

        fun from(id: Identifier) = LOOKUP[id]

        fun from(string: String) = from(Identifier.of(string))
    }
}