package net.zekromaster.minecraft.ironchests.mixin;

import net.minecraft.class_110;
import net.minecraft.class_142;
import net.minecraft.class_18;
import net.minecraft.class_225;
import net.minecraft.class_54;
import net.zekromaster.minecraft.ironchests.upgrades.ChestUpgrade;
import net.zekromaster.minecraft.ironchests.upgrades.UpgradeStorage;
import net.zekromaster.minecraft.ironchests.upgrades.UpgradeUtils;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

import java.util.Random;

@Mixin(class_110.class)
public class ChestMixin {

    @Shadow private Random random;

    @Inject(method = "onUse", at=@At("HEAD"), cancellable = true)
    void onUseMixin(class_18 world, int x, int y, int z, class_54 player, CallbackInfoReturnable<Boolean> cir) {
        var chest = (class_225) world.method_1777(x, y, z);
        var hand = player.method_502();
        if (hand != null) {
            if (hand.method_694() instanceof ChestUpgrade upgrade) {
                if (upgrade.upgrade(world, x, y, z, player, chest)) {
                    hand.field_751--;
                }
                cir.setReturnValue(true);
            }
        }
    }

    @Inject(method = "onBreak", at=@At("HEAD"), cancellable = true)
    void onBreakMixin(class_18 world, int x, int y, int z, CallbackInfo ci) {
        if (UpgradeUtils.isMidUpgrade(world.method_1777(x, y, z))) {
            ci.cancel();
        }
    }

    @Inject(
        method = "onBreak",
        at = @At(value = "INVOKE", target = "Lnet/minecraft/block/BlockWithEntity;onBreak(Lnet/minecraft/world/World;III)V")
    )
    void upgradeStorageMixin(class_18 world, int x, int y, int z, CallbackInfo ci) {
        var upgradeStorage = UpgradeStorage.capability().get(world, x, y, z, null);
        if (upgradeStorage != null) {
            for (var upgrade: upgradeStorage.getStorage()) {
                var dropX = this.random.nextFloat() * 0.8f + 0.1f;
                var dropY = this.random.nextFloat() * 0.8f + 0.1f;
                var dropZ = this.random.nextFloat() * 0.8f + 0.1f;
                var drop = new class_142(
                    world,
                    (x + dropX),
                    (y + dropY),
                    (z + dropZ),
                    upgrade
                );
                var velocityScale = 0.05f;
                drop.field_1603 = (this.random.nextGaussian() * velocityScale);
                drop.field_1604 = (this.random.nextGaussian() * velocityScale + 0.2f);
                drop.field_1605 = (this.random.nextGaussian() * velocityScale);
                world.method_210(drop);
            }
        }
    }
}
