@file:JvmName("IronChests")

package net.zekromaster.minecraft.ironchests

import com.google.common.collect.HashBasedTable
import com.google.common.collect.Table
import net.minecraft.entity.player.PlayerEntity
import net.modificationstation.stationapi.api.state.property.BooleanProperty
import net.modificationstation.stationapi.api.state.property.EnumProperty
import net.modificationstation.stationapi.api.util.Namespace
import net.modificationstation.stationapi.api.util.math.Direction
import net.zekromaster.minecraft.ironchests.IronChestMaterial.Companion.DIAMOND
import net.zekromaster.minecraft.ironchests.IronChestMaterial.Companion.GOLD
import net.zekromaster.minecraft.ironchests.IronChestMaterial.Companion.IRON
import net.zekromaster.minecraft.ironchests.IronChestMaterial.Companion.WOOD
import java.util.function.Predicate
import kotlin.math.floor

val NAMESPACE = Namespace.of("ironchests")

object IronChestsBlockStates {
    @JvmField
    val FACING: EnumProperty<Direction> = EnumProperty.of("facing", Direction::class.java, Predicate { it.axis.isHorizontal })
    @JvmField
    val HAS_OBSIDIAN_UPGRADE: BooleanProperty = BooleanProperty.of("obsidian")
}

fun PlayerEntity.placementFacing(): Direction {
    val direction = floor((this.yaw * 4.0f / 360.0f).toDouble() + 0.5).toInt() and 3
    return when (direction) {
        0 -> Direction.NORTH
        1 -> Direction.EAST
        2 -> Direction.SOUTH
        3 -> Direction.WEST
        else -> Direction.NORTH
    }
}

data class TierTransition(
    val isHalfStep: Boolean = false,
    val hasUpgrade: Boolean = true
)

val TRANSITIONS: Table<IronChestMaterial, IronChestMaterial, TierTransition> = run {
    val table = HashBasedTable.create<IronChestMaterial, IronChestMaterial, TierTransition>()
    table.put(WOOD, IRON, TierTransition())
    table.put(IRON, GOLD, TierTransition())
    table.put(GOLD, DIAMOND, TierTransition(isHalfStep = true))
    table
}