package net.zekromaster.minecraft.sheepeatgrass.mixin;

import net.zekromaster.minecraft.sheepeatgrass.IEatableBlock;
import net.minecraft.class_17;
import net.minecraft.class_18;
import net.minecraft.class_189;
import net.minecraft.class_258;
import net.minecraft.class_54;
import net.minecraft.class_57;
import net.minecraft.class_613;
import net.minecraft.class_63;
import net.zekromaster.minecraft.sheepeatgrass.EatingSheep;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(class_613.class)
public abstract class SheepEntityMixin extends class_258 implements EatingSheep {
	@Shadow public abstract void setSheared(boolean arg);

	@Shadow public abstract boolean isSheared();

	@Unique
	private int sheepTimer = 0;

	@Unique
	private class_63 currentEating;

	protected SheepEntityMixin(class_18 arg) {
		super(arg);
	}

	@Inject(at = @At("HEAD"), method = "damage")
	private void damage(class_57 arg, int i, CallbackInfoReturnable<Boolean> cir) {
		if (arg instanceof class_54 p) {
			this.method_1323(p);
		}
	}

	@Override
	protected boolean method_640() {
		return this.sheepTimer > 0;
	}

	@Override
	protected void method_910() {
		super.method_910();

		int x = class_189.method_645(this.field_1600);
		int y = class_189.method_645(this.field_1601);
		int z = class_189.method_645(this.field_1602);

		if(!this.method_633() && this.sheepTimer <= 0 && this.field_1644.nextInt(1000) == 0 && this.isSheared()) {
			// For now, eating on top and bottom
			var blockSharedSpace = field_1596.method_1776(x, y, z);
			var blockBelow = field_1596.method_1776(x, y - 1, z);
			this.currentEating = null;
			if (class_17.field_1937[blockSharedSpace] instanceof IEatableBlock) {
				this.currentEating = new class_63(x, y, z);
			} else if (class_17.field_1937[blockBelow] instanceof IEatableBlock) {
				this.currentEating = new class_63(x, y-1, z);
			}

			if (this.currentEating != null) {
				this.sheepTimer = 40;
			}
		} else if(this.sheepTimer == 4) {

			if (this.currentEating != null) {
				var block = class_17.field_1937[field_1596.method_1776(currentEating.field_1482, currentEating.field_1483, currentEating.field_1484)];
				if (block instanceof IEatableBlock e) {
					if (e.canEat(
							field_1596,
							currentEating.field_1482, currentEating.field_1483, currentEating.field_1484,
							this,
							x, y, z
					)) {
						e.onEat(
								field_1596,
								currentEating.field_1482, currentEating.field_1483, currentEating.field_1484,
								this,
								x, y, z
						);
						this.setSheared(false);
					}
				}
			}
		}
	}

	@Override
	public void method_937() {
		super.method_937();
		if(this.sheepTimer > 0) {
			--this.sheepTimer;
		}
	}

	public float sheepEatGrass$getHeadRotationPointY(float arg) {
		if (this.sheepTimer <= 0) {
			return 0.0F;
		}

		if (this.sheepTimer >= 4 && this.sheepTimer <= 36) {
			return 1.0F;
		}

		if (this.sheepTimer < 4) {
			return (this.sheepTimer - arg) / 4.0F;
		}

		return -((this.sheepTimer - 40) - arg) / 4.0F;
	}

	public float sheepEatGrass$getHeadRotationAngleX(float arg) {
		if (this.sheepTimer > 4 && this.sheepTimer <= 36) {
			float val = ((this.sheepTimer - 4) - arg) / 32.0F;
			return (float)Math.PI * 0.2F + 0.2199115F * class_189.method_644(val * 28.7F);
		}

		if (this.sheepTimer > 0) {
			return (float)Math.PI * 0.2F;
		}

		return this.field_1607 / (180.0F / (float)Math.PI);
	}
}
