/*
 * Decompiled with CFR 0.152.
 */
package net.zekromaster.minecraft.sheepeatgrass.mixin;

import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_127;
import net.minecraft.class_17;
import net.minecraft.class_18;
import net.minecraft.class_189;
import net.minecraft.class_258;
import net.minecraft.class_54;
import net.minecraft.class_57;
import net.minecraft.class_613;
import net.minecraft.class_63;
import net.zekromaster.minecraft.sheepeatgrass.EatingSheep;
import net.zekromaster.minecraft.sheepeatgrass.IEatableBlock;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_613.class})
public abstract class SheepEntityMixin
extends class_258
implements EatingSheep {
    @Unique
    private static final byte EATING_STATUS = 4;
    @Unique
    private int sheepTimer = 0;
    @Unique
    private class_63 currentEating;

    @Shadow
    public abstract void method_2045(boolean var1);

    @Shadow
    public abstract boolean method_2048();

    protected SheepEntityMixin(class_18 arg) {
        super(arg);
    }

    @Inject(at={@At(value="HEAD")}, method={"damage"})
    private void damage(class_57 arg, int i, CallbackInfoReturnable<Boolean> cir) {
        if (arg instanceof class_54) {
            class_54 p = (class_54)arg;
            this.method_1323(p);
        }
    }

    protected boolean method_640() {
        return this.sheepTimer > 0;
    }

    @Unique
    private void startEating() {
        int x = class_189.method_645((double)this.field_1600);
        int y = class_189.method_645((double)this.field_1601);
        int z = class_189.method_645((double)this.field_1602);
        int blockSharedSpace = this.field_1596.method_1776(x, y, z);
        int blockBelow = this.field_1596.method_1776(x, y - 1, z);
        this.currentEating = null;
        if (class_17.field_1937[blockSharedSpace] instanceof IEatableBlock) {
            this.currentEating = new class_63(x, y, z);
        } else if (class_17.field_1937[blockBelow] instanceof IEatableBlock) {
            this.currentEating = new class_63(x, y - 1, z);
        }
        if (this.currentEating != null) {
            this.sheepTimer = 40;
        }
    }

    protected void method_910() {
        super.method_910();
        if (this.method_2048()) {
            if (!this.field_1596.field_180 && !this.method_633() && this.sheepTimer <= 0 && this.field_1644.nextInt(1000) == 0) {
                this.startEating();
                this.field_1596.method_185((class_57)this, (byte)4);
            } else if (this.sheepTimer == 4 && this.currentEating != null) {
                IEatableBlock e;
                int x = class_189.method_645((double)this.field_1600);
                int y = class_189.method_645((double)this.field_1601);
                int z = class_189.method_645((double)this.field_1602);
                class_17 block = class_17.field_1937[this.field_1596.method_1776(this.currentEating.field_1482, this.currentEating.field_1483, this.currentEating.field_1484)];
                if (block instanceof IEatableBlock && (e = (IEatableBlock)block).canEat(this.field_1596, this.currentEating.field_1482, this.currentEating.field_1483, this.currentEating.field_1484, (class_127)this, x, y, z)) {
                    e.onEat(this.field_1596, this.currentEating.field_1482, this.currentEating.field_1483, this.currentEating.field_1484, (class_127)this, x, y, z);
                    this.method_2045(false);
                }
            }
        }
    }

    @Environment(value=EnvType.CLIENT)
    public void method_1313(byte status) {
        if (status == 4) {
            this.startEating();
        } else {
            super.method_1313(status);
        }
    }

    public void method_937() {
        super.method_937();
        if (this.sheepTimer > 0) {
            --this.sheepTimer;
        }
    }

    @Override
    public float sheepEatGrass$getHeadRotationPointY(float arg) {
        if (this.sheepTimer <= 0) {
            return 0.0f;
        }
        if (this.sheepTimer >= 4 && this.sheepTimer <= 36) {
            return 1.0f;
        }
        if (this.sheepTimer < 4) {
            return ((float)this.sheepTimer - arg) / 4.0f;
        }
        return -((float)(this.sheepTimer - 40) - arg) / 4.0f;
    }

    @Override
    public float sheepEatGrass$getHeadRotationAngleX(float arg) {
        if (this.sheepTimer > 4 && this.sheepTimer <= 36) {
            float val = ((float)(this.sheepTimer - 4) - arg) / 32.0f;
            return 0.62831855f + 0.2199115f * class_189.method_644((float)(val * 28.7f));
        }
        if (this.sheepTimer > 0) {
            return 0.62831855f;
        }
        return this.field_1607 / 57.295776f;
    }
}

