package net.zekromaster.minecraft.splitwoods;

import net.mine_diver.unsafeevents.listener.EventListener;
import net.minecraft.class_15;
import net.minecraft.class_17;
import net.minecraft.class_31;
import net.modificationstation.stationapi.api.event.recipe.RecipeRegisterEvent;
import net.modificationstation.stationapi.api.event.registry.BlockRegistryEvent;
import net.modificationstation.stationapi.api.mod.entrypoint.Entrypoint;
import net.modificationstation.stationapi.api.mod.entrypoint.EntrypointManager;
import net.modificationstation.stationapi.api.mod.entrypoint.EventBusPolicy;
import net.modificationstation.stationapi.api.recipe.CraftingRegistry;
import net.modificationstation.stationapi.api.template.block.TemplateBlock;
import net.modificationstation.stationapi.api.util.Namespace;
import net.modificationstation.stationapi.api.util.Null;
import net.zekromaster.minecraft.splitwoods.templates.SlabBlockTemplate;
import net.zekromaster.minecraft.splitwoods.templates.StairsBlockTemplate;

import java.lang.invoke.MethodHandles;

import static net.minecraft.class_17.field_1929;

@Entrypoint(eventBus = @EventBusPolicy(registerInstance = false))
public class SplitWoods {
    static {
        EntrypointManager.registerLookup(MethodHandles.lookup());
    }

    @Entrypoint.Namespace
    public static Namespace namespace = Null.get();

    public static class_17[] blocks;
    public static class_17 BIRCH_PLANKS;
    public static class_17 SPRUCE_PLANKS;
    public static class_17 BIRCH_SLAB;
    public static class_17 SPRUCE_SLAB;
    public static class_17 BIRCH_STAIRS;
    public static class_17 SPRUCE_STAIRS;

    @EventListener
    private static void blockListener(BlockRegistryEvent event) {
        class_17.field_1949.setTranslationKey(namespace.id("oak_planks"));
        BIRCH_PLANKS = new TemplateBlock(namespace.id("birch_planks"), class_15.field_982)
                .method_1587(2.0F)
                .method_1585(5.0F)
                .method_1580(field_1929)
                .setTranslationKey(namespace.id("birch_planks"));
        SPRUCE_PLANKS = new TemplateBlock(namespace.id("spruce_planks"), class_15.field_982)
                .method_1587(2.0F)
                .method_1585(5.0F)
                .method_1580(field_1929)
                .setTranslationKey(namespace.id("spruce_planks"));

        BIRCH_SLAB = new SlabBlockTemplate(namespace.id("birch_slab"), BIRCH_PLANKS)
                .method_1587(2.0F)
                .method_1585(5.0F)
                .method_1580(field_1929)
                .setTranslationKey(namespace.id("birch_slab"));
        SPRUCE_SLAB = new SlabBlockTemplate(namespace.id("spruce_slab"), SPRUCE_PLANKS)
                .method_1587(2.0F)
                .method_1585(5.0F)
                .method_1580(field_1929)
                .setTranslationKey(namespace.id("spruce_slab"));

        class_17.field_1894.setTranslationKey(namespace.id("oak_stairs"));
        BIRCH_STAIRS = new StairsBlockTemplate(namespace.id("birch_stairs"), BIRCH_PLANKS)
                .method_1587(2.0F)
                .method_1585(5.0F)
                .method_1580(field_1929)
                .setTranslationKey(namespace.id("birch_slab"));
        SPRUCE_STAIRS = new StairsBlockTemplate(namespace.id("spruce_stairs"), SPRUCE_PLANKS)
                .method_1587(2.0F)
                .method_1585(5.0F)
                .method_1580(field_1929)
                .setTranslationKey(namespace.id("spruce_slab"));

        blocks = new class_17[]
        { BIRCH_PLANKS
        , SPRUCE_PLANKS
        , BIRCH_SLAB
        , SPRUCE_SLAB
        , BIRCH_STAIRS
        , SPRUCE_STAIRS
        };
    }

    @EventListener
    private static void recipeListener(RecipeRegisterEvent event) {

        if (event.recipeId.equals(RecipeRegisterEvent.Vanilla.CRAFTING_SHAPELESS.type())) {
            CraftingRegistry.addShapelessRecipe(new class_31(class_17.field_1949, 4), new class_31(class_17.field_1831, 1, 0));
            CraftingRegistry.addShapelessRecipe(new class_31(BIRCH_PLANKS, 4), new class_31(class_17.field_1831, 1, 2));
            CraftingRegistry.addShapelessRecipe(new class_31(SPRUCE_PLANKS, 4), new class_31(class_17.field_1831, 1, 1));
        }

        if (event.recipeId.equals(RecipeRegisterEvent.Vanilla.CRAFTING_SHAPED.type())) {
            CraftingRegistry.addShapedRecipe(new class_31(class_17.field_1885, 6, 2), "xxx", 'x', class_17.field_1949);
            CraftingRegistry.addShapedRecipe(new class_31(BIRCH_SLAB, 6), "xxx", 'x', BIRCH_PLANKS);
            CraftingRegistry.addShapedRecipe(new class_31(SPRUCE_SLAB, 6), "xxx", 'x', SPRUCE_PLANKS);

            CraftingRegistry.addShapedRecipe(new class_31(class_17.field_1894, 4), "x  ", "xx ", "xxx", 'x', class_17.field_1949);
            CraftingRegistry.addShapedRecipe(new class_31(BIRCH_STAIRS, 4), "x  ", "xx ", "xxx", 'x', BIRCH_PLANKS);
            CraftingRegistry.addShapedRecipe(new class_31(SPRUCE_STAIRS, 4), "x  ", "xx ", "xxx", 'x', SPRUCE_PLANKS);
        }

    }

}
