// Based on code from DanyGames2014's Tropicraft, see COPYING.Tropicraft

package net.zekromaster.minecraft.splitwoods.templates;

import net.minecraft.class_17;
import net.minecraft.class_18;
import net.minecraft.class_25;
import net.minecraft.class_54;
import net.modificationstation.stationapi.api.block.BlockState;
import net.modificationstation.stationapi.api.item.ItemPlacementContext;
import net.modificationstation.stationapi.api.state.StateManager;
import net.modificationstation.stationapi.api.state.property.EnumProperty;
import net.modificationstation.stationapi.api.template.block.TemplateBlock;
import net.modificationstation.stationapi.api.util.Identifier;
import net.modificationstation.stationapi.api.util.math.Direction;

import java.util.ArrayList;

public class StairsBlockTemplate extends TemplateBlock {

    public static final EnumProperty<Direction> FACING = EnumProperty.of("facing", Direction.class, dir -> dir.getAxis().isHorizontal());

    class_17 block;

    public StairsBlockTemplate(Identifier identifier, class_17 block) {
        super(identifier, block.field_1900);
        this.block = block;
    }

    @Override
    public void appendProperties(StateManager.Builder<class_17, BlockState> builder) {
        super.appendProperties(builder);
        builder.add(FACING);
    }

    @Override
    public BlockState getPlacementState(ItemPlacementContext context) {
        class_54 player = context.getPlayer();
        BlockState state = getDefaultState();
        Direction facing = Direction.fromRotation(player == null ? 0 : player.field_1606);
        return state.with(FACING, facing);
    }

    @Override
    public void method_1562(class_18 world, int x, int y, int z, class_25 box, ArrayList boxes) {
        Direction facing = world.getBlockState(x, y, z).get(FACING);
        if (facing == Direction.SOUTH) {
            this.method_1578(0.0F, 0.0F, 0.0F, 0.5F, 0.5F, 1.0F);
            super.method_1562(world, x, y, z, box, boxes);
            this.method_1578(0.5F, 0.0F, 0.0F, 1.0F, 1.0F, 1.0F);
            super.method_1562(world, x, y, z, box, boxes);
        } else if (facing == Direction.NORTH) {
            this.method_1578(0.0F, 0.0F, 0.0F, 0.5F, 1.0F, 1.0F);
            super.method_1562(world, x, y, z, box, boxes);
            this.method_1578(0.5F, 0.0F, 0.0F, 1.0F, 0.5F, 1.0F);
            super.method_1562(world, x, y, z, box, boxes);
        } else if (facing == Direction.WEST) {
            this.method_1578(0.0F, 0.0F, 0.0F, 1.0F, 0.5F, 0.5F);
            super.method_1562(world, x, y, z, box, boxes);
            this.method_1578(0.0F, 0.0F, 0.5F, 1.0F, 1.0F, 1.0F);
            super.method_1562(world, x, y, z, box, boxes);
        } else if (facing == Direction.EAST) {
            this.method_1578(0.0F, 0.0F, 0.0F, 1.0F, 1.0F, 0.5F);
            super.method_1562(world, x, y, z, box, boxes);
            this.method_1578(0.0F, 0.0F, 0.5F, 1.0F, 0.5F, 1.0F);
            super.method_1562(world, x, y, z, box, boxes);
        }

        this.method_1578(0.0F, 0.0F, 0.0F, 1.0F, 1.0F, 1.0F);
    }

    @Override
    public boolean method_1623() {
        return false;
    }

    @Override
    public boolean method_1620() {
        return false;
    }
}
