/*
 * Decompiled with CFR 0.152.
 */
package net.zekromaster.minecraft.terminal.attachments;

import com.google.common.base.Suppliers;
import java.util.function.Supplier;
import net.modificationstation.stationapi.api.util.Identifier;
import net.zekromaster.minecraft.terminal.nbt.NbtCodec;
import net.zekromaster.minecraft.terminal.network.NetworkCodec;
import org.jetbrains.annotations.Nullable;

public final class AttachmentType<T> {
    private final Supplier<T> defaultValue;
    public final Class<T> clazz;
    public final Identifier identifier;
    @Nullable
    public final NbtCodec<T> nbtCodec;
    @Nullable
    public final NetworkCodec<T> networkCodec;

    private AttachmentType(Identifier identifier, Class<T> clazz, Supplier<T> defaultValue, @Nullable NbtCodec<T> nbtCodec, @Nullable NetworkCodec<T> networkCodec) {
        this.identifier = identifier;
        this.clazz = clazz;
        this.defaultValue = defaultValue;
        this.nbtCodec = nbtCodec;
        this.networkCodec = networkCodec;
    }

    public T defaultValue() {
        return this.defaultValue.get();
    }

    public static <T> AttachmentTypeBuilder<T> create(Identifier identifier, Class<T> clazz, Supplier<T> defaultValue) {
        return new AttachmentTypeBuilder<T>(identifier, clazz, defaultValue);
    }

    public static <T> AttachmentTypeBuilder<T> create(Identifier identifier, Class<T> clazz, T defaultValue) {
        return AttachmentType.create(identifier, clazz, Suppliers.ofInstance(defaultValue));
    }

    public static final class AttachmentTypeBuilder<T> {
        private final Class<T> clazz;
        private final Identifier identifier;
        private final Supplier<T> defaultValue;
        @Nullable
        private NbtCodec<T> nbtCodec;
        @Nullable
        private NetworkCodec<T> networkCodec;

        private AttachmentTypeBuilder(Identifier identifier, Class<T> clazz, Supplier<T> defaultValue) {
            this.identifier = identifier;
            this.clazz = clazz;
            this.defaultValue = defaultValue;
            this.nbtCodec = null;
            this.networkCodec = null;
        }

        public AttachmentTypeBuilder<T> nbt(@Nullable NbtCodec<T> codec) {
            this.nbtCodec = codec;
            return this;
        }

        public AttachmentTypeBuilder<T> sync(@Nullable NetworkCodec<T> codec) {
            this.networkCodec = codec;
            return this;
        }

        public AttachmentType<T> build() {
            return new AttachmentType<T>(this.identifier, this.clazz, this.defaultValue, this.nbtCodec, this.networkCodec);
        }
    }
}

