/*
 * Decompiled with CFR 0.152.
 */
package net.zekromaster.minecraft.terminal.attachments;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.class_187;
import net.minecraft.class_8;
import net.modificationstation.stationapi.api.util.Identifier;
import net.modificationstation.stationapi.mixin.nbt.NbtCompoundAccessor;
import net.zekromaster.minecraft.terminal.attachments.AttachmentStore;
import net.zekromaster.minecraft.terminal.attachments.AttachmentType;
import net.zekromaster.minecraft.terminal.attachments.AttachmentTypeRegistry;
import org.jetbrains.annotations.Nullable;

public class SimpleAttachmentStore
implements AttachmentStore {
    private final Map<AttachmentType<?>, Object> attachments = new HashMap();

    @Override
    @Nullable
    public <T> T getDataOrNull(AttachmentType<T> attachmentType) {
        return (T)this.attachments.get(attachmentType);
    }

    @Override
    public <T> void setData(AttachmentType<T> attachmentType, T data) {
        if (data == null) {
            this.attachments.remove(attachmentType);
        } else {
            this.attachments.put(attachmentType, data);
        }
    }

    @Override
    public boolean hasData(AttachmentType<?> attachmentType) {
        return this.attachments.containsKey(attachmentType);
    }

    public class_8 toNbt() {
        class_8 compound = new class_8();
        for (AttachmentType<?> attachmentType : this.attachments.keySet()) {
            if (attachmentType.nbtCodec == null) continue;
            class_187 individualAttachment = attachmentType.nbtCodec.toNbt(this.getData(attachmentType));
            compound.method_1017(attachmentType.identifier.toString(), individualAttachment);
        }
        return compound;
    }

    public void fromNbt(class_8 nbt) {
        Map allAttachments = ((NbtCompoundAccessor)nbt).stationapi$getEntries();
        for (Map.Entry attachment : allAttachments.entrySet()) {
            AttachmentType attachmentType = (AttachmentType)AttachmentTypeRegistry.INSTANCE.get(Identifier.of((String)((String)attachment.getKey())));
            if (attachmentType == null || attachmentType.nbtCodec == null) continue;
            Object attachmentValue = attachmentType.nbtCodec.fromNbt((class_187)allAttachments.get(attachmentType.identifier.toString()));
            this.attachments.put(attachmentType, attachmentValue);
        }
    }
}

