/*
 * Decompiled with CFR 0.152.
 */
package net.zekromaster.minecraft.terminal.attachments.packets;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import net.minecraft.class_169;
import net.minecraft.class_240;
import net.minecraft.class_55;
import net.modificationstation.stationapi.api.network.packet.IdentifiablePacket;
import net.modificationstation.stationapi.api.util.Identifier;
import net.zekromaster.minecraft.terminal.attachments.AttachmentType;
import net.zekromaster.minecraft.terminal.attachments.AttachmentTypeRegistry;
import net.zekromaster.minecraft.terminal.attachments.inject.AttachmentsNetworkHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UpdateBlockEntityAttachmentPacket<T>
extends class_169
implements IdentifiablePacket {
    private static final Logger LOG = LoggerFactory.getLogger(UpdateBlockEntityAttachmentPacket.class);
    public static final Identifier ID = Identifier.of((String)"terminal:update_block_entity_attachments");
    private int x;
    private int y;
    private int z;
    private AttachmentType<T> attachmentType;
    private T attachment;

    public UpdateBlockEntityAttachmentPacket() {
        this(0, 0, 0, null, null);
    }

    public UpdateBlockEntityAttachmentPacket(int x, int y, int z, AttachmentType<T> attachmentType, T attachment) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.attachmentType = attachmentType;
        this.attachment = attachment;
    }

    public void method_806(DataInputStream stream) {
        try {
            this.x = stream.readInt();
            this.y = stream.readInt();
            this.z = stream.readInt();
            this.attachmentType = (AttachmentType)AttachmentTypeRegistry.INSTANCE.get(Identifier.of((String)UpdateBlockEntityAttachmentPacket.method_802((DataInputStream)stream, (int)128)));
            if (this.attachmentType == null) {
                LOG.error("Attempting to receive non-existing attachment over the network");
                return;
            }
            if (this.attachmentType.networkCodec == null) {
                LOG.error("Attempting to receive non-syncable attachment over the network");
                return;
            }
            this.attachment = this.attachmentType.networkCodec.read(stream);
        }
        catch (IOException e) {
            LOG.error("Caught exception while trying to synchronise attachments");
            LOG.error("e: ", (Throwable)e);
        }
    }

    public void method_807(DataOutputStream stream) {
        try {
            stream.writeInt(this.x);
            stream.writeInt(this.y);
            stream.writeInt(this.z);
            if (this.attachmentType == null) {
                return;
            }
            UpdateBlockEntityAttachmentPacket.method_804((String)this.attachmentType.identifier.toString(), (DataOutputStream)stream);
            if (this.attachmentType.networkCodec == null || this.attachment == null) {
                LOG.error("Attempting to send non-syncable attachment over the network");
                return;
            }
            this.attachmentType.networkCodec.write(stream, this.attachment);
        }
        catch (IOException e) {
            LOG.error("Caught exception while trying to synchronise attachments");
            LOG.error("e: ", (Throwable)e);
        }
    }

    public void method_808(class_240 networkHandler) {
        class_55 be = ((AttachmentsNetworkHandler)networkHandler).terminal$attachments$getWorld().method_1777(this.x, this.y, this.z);
        be.terminal$attachments$setDataSilently(this.attachmentType, this.attachment);
    }

    public int method_798() {
        if (this.attachmentType.networkCodec == null) {
            return 12 + this.attachmentType.identifier.toString().length();
        }
        return 12 + this.attachmentType.identifier.toString().length() + this.attachmentType.networkCodec.size(this.attachment);
    }

    public Identifier getId() {
        return ID;
    }
}

