/*
 * Decompiled with CFR 0.152.
 */
package net.zekromaster.minecraft.terminal.attachments.packets;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import net.minecraft.class_169;
import net.minecraft.class_240;
import net.minecraft.class_57;
import net.modificationstation.stationapi.api.network.packet.IdentifiablePacket;
import net.modificationstation.stationapi.api.util.Identifier;
import net.zekromaster.minecraft.terminal.attachments.AttachmentType;
import net.zekromaster.minecraft.terminal.attachments.AttachmentTypeRegistry;
import net.zekromaster.minecraft.terminal.attachments.inject.AttachmentsNetworkHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UpdateEntityAttachmentPacket<T>
extends class_169
implements IdentifiablePacket {
    private static final Logger LOG = LoggerFactory.getLogger(UpdateEntityAttachmentPacket.class);
    public static final Identifier ID = Identifier.of((String)"terminal:update_entity_attachments");
    private int entityId = 0;
    private AttachmentType<T> attachmentType;
    private T attachment;

    public UpdateEntityAttachmentPacket() {
        this(0, null, null);
    }

    public UpdateEntityAttachmentPacket(int entityId, AttachmentType<T> attachmentType, T attachment) {
        this.attachmentType = attachmentType;
        this.attachment = attachment;
    }

    public void method_806(DataInputStream stream) {
        try {
            this.entityId = stream.readInt();
            this.attachmentType = (AttachmentType)AttachmentTypeRegistry.INSTANCE.get(Identifier.of((String)UpdateEntityAttachmentPacket.method_802((DataInputStream)stream, (int)128)));
            if (this.attachmentType == null) {
                LOG.error("Attempting to receive non-existing attachment over the network");
                return;
            }
            if (this.attachmentType.networkCodec == null) {
                LOG.error("Attempting to receive non-syncable attachment over the network");
                return;
            }
            this.attachment = this.attachmentType.networkCodec.read(stream);
        }
        catch (IOException e) {
            LOG.error("Caught exception while trying to synchronise attachments");
            LOG.error("e: ", (Throwable)e);
        }
    }

    public void method_807(DataOutputStream stream) {
        try {
            stream.writeInt(this.entityId);
            if (this.attachmentType == null) {
                return;
            }
            UpdateEntityAttachmentPacket.method_804((String)this.attachmentType.identifier.toString(), (DataOutputStream)stream);
            if (this.attachmentType.networkCodec == null || this.attachment == null) {
                LOG.error("Attempting to send non-syncable attachment over the network");
                return;
            }
            this.attachmentType.networkCodec.write(stream, this.attachment);
        }
        catch (IOException e) {
            LOG.error("Caught exception while trying to synchronise attachments");
            LOG.error("e: ", (Throwable)e);
        }
    }

    public void method_808(class_240 networkHandler) {
        class_57 entity = ((AttachmentsNetworkHandler)networkHandler).terminal$attachments$getEntity(this.entityId);
        entity.terminal$attachments$setDataSilently(this.attachmentType, this.attachment);
    }

    public int method_798() {
        if (this.attachmentType.networkCodec == null) {
            return 4 + this.attachmentType.identifier.toString().length();
        }
        return 4 + this.attachmentType.identifier.toString().length() + this.attachmentType.networkCodec.size(this.attachment);
    }

    public Identifier getId() {
        return ID;
    }
}

