/*
 * Decompiled with CFR 0.152.
 */
package net.zekromaster.minecraft.terminal.capabilities;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import net.minecraft.class_17;
import net.minecraft.class_18;
import net.minecraft.class_339;
import net.minecraft.class_55;
import net.modificationstation.stationapi.api.block.BlockState;
import net.modificationstation.stationapi.api.util.Identifier;
import net.modificationstation.stationapi.api.util.math.Direction;
import net.zekromaster.minecraft.terminal.mixin.capabilities.BlockEntityAccessor;
import org.jetbrains.annotations.Nullable;

public final class BlockCapability<T, CTX> {
    final Multimap<String, BlockEntityCapabilityHandler<T, CTX>> blockEntityHandlers = ArrayListMultimap.create();
    final Multimap<class_17, BlockCapabilityHandler<T, CTX>> blockHandlers = ArrayListMultimap.create();
    public final Identifier identifier;
    public final Class<T> clazz;
    public final Class<CTX> ctxClass;

    private BlockCapability(Identifier identifier, Class<T> clazz, Class<CTX> ctxClass) {
        this.identifier = identifier;
        this.clazz = clazz;
        this.ctxClass = ctxClass;
    }

    public static <T, CTX> BlockCapability<T, CTX> create(Identifier identifier, Class<T> clazz, Class<CTX> ctxClass) {
        return new BlockCapability<T, CTX>(identifier, clazz, ctxClass);
    }

    public static <T> BlockCapability<T, @Nullable Direction> createSided(Identifier identifier, Class<T> clazz) {
        return new BlockCapability<T, Direction>(identifier, clazz, Direction.class);
    }

    public static <T> BlockCapability<T, Void> createVoid(Identifier identifier, Class<T> clazz) {
        return new BlockCapability<T, Void>(identifier, clazz, Void.class);
    }

    @Nullable
    public T get(class_18 world, class_339 blockPos, CTX ctx) {
        return this.get(world, blockPos.field_2100, blockPos.field_2101, blockPos.field_2102, ctx);
    }

    @Nullable
    public T get(class_18 world, int x, int y, int z, CTX ctx) {
        Object value;
        String id;
        class_55 blockEntity = world.method_1777(x, y, z);
        if (blockEntity != null && (id = BlockEntityAccessor.getClassToId().get(blockEntity.getClass())) != null) {
            for (Object handler : this.blockEntityHandlers.get((Object)id)) {
                value = handler.get(blockEntity, ctx);
                if (value == null) continue;
                return value;
            }
        }
        BlockState block = world.getBlockState(x, y, z);
        for (Object handler : this.blockHandlers.get((Object)block.getBlock())) {
            value = handler.get(world, new class_339(x, y, z), ctx);
            if (value == null) continue;
            return value;
        }
        return null;
    }

    @FunctionalInterface
    public static interface BlockEntityCapabilityHandler<T, CTX> {
        public T get(class_55 var1, CTX var2);
    }

    @FunctionalInterface
    public static interface BlockCapabilityHandler<T, CTX> {
        public T get(class_18 var1, class_339 var2, CTX var3);
    }
}

