/*
 * Decompiled with CFR 0.152.
 */
package net.zekromaster.minecraft.terminal.capabilities;

import net.mine_diver.unsafeevents.Event;
import net.minecraft.class_124;
import net.minecraft.class_17;
import net.zekromaster.minecraft.terminal.capabilities.BlockCapability;
import net.zekromaster.minecraft.terminal.capabilities.EntityCapability;
import net.zekromaster.minecraft.terminal.capabilities.ItemCapability;

public interface CapabilityEvents {

    public static class RegisterEntityCapabilitiesEvent
    extends Event {
        public <T, CTX> void registerEntity(EntityCapability<T, CTX> capability, EntityCapability.EntityCapabilityHandler<T, CTX> handler, String ... entities) {
            for (String entity : entities) {
                capability.handlers.put((Object)entity, handler);
            }
        }
    }

    public static class RegisterBlockEntityCapabilitiesEvent
    extends Event {
        public <T, CTX> void registerBlockEntity(BlockCapability<T, CTX> capability, BlockCapability.BlockEntityCapabilityHandler<T, CTX> handler, String ... blockEntities) {
            for (String be : blockEntities) {
                capability.blockEntityHandlers.put((Object)be, handler);
            }
        }
    }

    public static class RegisterBlockCapabilitiesEvent
    extends Event {
        public <T, CTX> void registerBlock(BlockCapability<T, CTX> capability, BlockCapability.BlockCapabilityHandler<T, CTX> handler, class_17 ... blocks) {
            for (class_17 block : blocks) {
                capability.blockHandlers.put((Object)block, handler);
            }
        }
    }

    public static class RegisterItemCapabilitiesEvent
    extends Event {
        public <T, CTX> void registerItem(ItemCapability<T, CTX> capability, ItemCapability.ItemCapabilityHandler<T, CTX> handler, class_124 ... items) {
            for (class_124 item : items) {
                capability.handlers.put((Object)item, handler);
            }
        }
    }
}

